/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import thelm.packagedauto.client.DistributorRenderer;
import thelm.packagedauto.network.PacketHandler;

public record DistributorBeamPacket(Vec3 source, Vec3 delta) {
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.source.f_82479_);
        buf.writeDouble(this.source.f_82480_);
        buf.writeDouble(this.source.f_82481_);
        buf.writeDouble(this.delta.f_82479_);
        buf.writeDouble(this.delta.f_82480_);
        buf.writeDouble(this.delta.f_82481_);
    }

    public static DistributorBeamPacket decode(FriendlyByteBuf buf) {
        Vec3 source = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        Vec3 delta = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        return new DistributorBeamPacket(source, delta);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistributorRenderer.INSTANCE.addBeam(this.source, this.delta));
        ctx.get().setPacketHandled(true);
    }

    public static void sendBeam(Vec3 source, Vec3 delta, ResourceKey<Level> dimension, double range) {
        PacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(source.f_82479_, source.f_82480_, source.f_82481_, range, dimension)), (Object)new DistributorBeamPacket(source, delta));
    }
}

