/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.PatternType;
import thelm.packagedauto.util.MiscHelper;

public class PackageItem
extends Item
implements IPackageItem {
    public static final PackageItem INSTANCE = new PackageItem();

    protected PackageItem() {
        super(new Item.Properties());
    }

    public static ItemStack makePackage(IPackageRecipeInfo recipeInfo, int index) {
        ItemStack stack = new ItemStack((ItemLike)INSTANCE);
        CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), recipeInfo);
        tag.m_128344_("Index", (byte)index);
        stack.m_41751_(tag);
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_ && player.m_6144_()) {
            ItemStack stack = player.m_21120_(hand).m_41777_();
            ItemStack stack1 = stack.m_41620_(1);
            IPackageRecipeInfo recipe = this.getRecipeInfo(stack1);
            int index = this.getIndex(stack1);
            if (recipe != null && recipe.validPatternIndex(index)) {
                List<IPackagePattern> patterns = recipe.getPatterns();
                IPackagePattern pattern = patterns.get(index);
                List<ItemStack> inputs = pattern.getInputs();
                for (int i = 0; i < inputs.size(); ++i) {
                    ItemStack input = inputs.get(i).m_41777_();
                    if (player.m_150109_().m_36054_(input)) continue;
                    ItemEntity item = new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), input);
                    item.m_32052_(player.m_20148_());
                    level.m_7967_((Entity)item);
                }
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        IPackageRecipeInfo recipe = this.getRecipeInfo(stack);
        int index = this.getIndex(stack);
        if (recipe != null && recipe.validPatternIndex(index)) {
            tooltip.add((Component)recipe.getRecipeType().getDisplayName().m_130946_(": "));
            for (ItemStack is : recipe.getOutputs()) {
                Item item = is.m_41720_();
                if (item instanceof IVolumePackageItem) {
                    IVolumePackageItem vp = (IVolumePackageItem)item;
                    IVolumeStackWrapper vs = vp.getVolumeStack(is);
                    tooltip.add((Component)Component.m_237113_((String)(is.m_41613_() + "x")).m_7220_(vs.getAmountDesc()).m_130946_(" ").m_7220_((Component)ComponentUtils.m_130748_((Component)vs.getDisplayName())));
                    continue;
                }
                tooltip.add((Component)Component.m_237113_((String)(is.m_41613_() + " ")).m_7220_(is.m_41611_()));
            }
            tooltip.add((Component)Component.m_237110_((String)"item.packagedauto.package.index", (Object[])new Object[]{index}));
            tooltip.add((Component)Component.m_237115_((String)"item.packagedauto.package.items"));
            List<ItemStack> recipeInputs = recipe.getInputs();
            List<ItemStack> packageItems = recipeInputs.subList(9 * index, Math.min(9 * index + 9, recipeInputs.size()));
            for (ItemStack is : packageItems) {
                Item item = is.m_41720_();
                if (item instanceof IVolumePackageItem) {
                    IVolumePackageItem vp = (IVolumePackageItem)item;
                    IVolumeStackWrapper vs = vp.getVolumeStack(is);
                    tooltip.add((Component)Component.m_237113_((String)(is.m_41613_() + "x")).m_7220_(vs.getAmountDesc()).m_130946_(" ").m_7220_((Component)ComponentUtils.m_130748_((Component)vs.getDisplayName())));
                    continue;
                }
                tooltip.add((Component)Component.m_237113_((String)(is.m_41613_() + " ")).m_7220_(is.m_41611_()));
            }
        }
        super.m_7373_(stack, level, tooltip, isAdvanced);
    }

    @Override
    public IPackageRecipeInfo getRecipeInfo(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return MiscHelper.INSTANCE.loadRecipe(tag);
        }
        return null;
    }

    @Override
    public int getIndex(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128445_("Index");
        }
        return -1;
    }

    @Override
    public PatternType getPatternType(ItemStack stack) {
        if (stack.m_41782_()) {
            return PatternType.fromName(stack.m_41783_().m_128461_("PatternType"));
        }
        return null;
    }
}

