/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei.category;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.block.PackagerBlock;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;

public class PackagingCategory
implements IRecipeCategory<IPackagePattern> {
    public static final RecipeType<IPackagePattern> TYPE = RecipeType.create((String)"packagedauto", (String)"packaging", IPackagePattern.class);
    public static final Component TITLE = Component.m_237115_((String)"jei.category.packagedauto.packaging");
    private final IDrawable background;
    private final IDrawable icon;

    public PackagingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(PackagedAutoJEIPlugin.BACKGROUND, 108, 64, 112, 54);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)PackagerBlock.INSTANCE));
    }

    public RecipeType<IPackagePattern> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IPackagePattern recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder slot;
        List<ItemStack> inputs = recipe.getInputs();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                slot = builder.addSlot(RecipeIngredientRole.INPUT, 1 + j * 18, 1 + i * 18);
                if (index >= inputs.size()) continue;
                slot.addItemStack(inputs.get(index));
            }
        }
        slot = builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 19);
        slot.addItemStack(recipe.getOutput());
    }
}

