/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import java.util.List;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.integration.jei.category.PackageContentsCategory;
import thelm.packagedauto.integration.jei.category.PackageProcessingCategory;
import thelm.packagedauto.integration.jei.category.PackageRecipeCategory;
import thelm.packagedauto.integration.jei.category.PackagingCategory;

public class PackageManagerPlugin
implements IRecipeManagerPlugin {
    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        Object object = focus.getTypedValue().getIngredient();
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (stack.m_41720_() instanceof IPackageItem) {
                switch (focus.getRole()) {
                    case INPUT: {
                        return List.of(PackageRecipeCategory.TYPE, PackageProcessingCategory.TYPE, PackageContentsCategory.TYPE);
                    }
                    case OUTPUT: {
                        return List.of(PackageRecipeCategory.TYPE, PackagingCategory.TYPE);
                    }
                }
            }
            if (stack.m_41720_() instanceof IPackageRecipeListItem) {
                switch (focus.getRole()) {
                    case INPUT: {
                        return List.of(PackageRecipeCategory.TYPE, PackageProcessingCategory.TYPE);
                    }
                    case OUTPUT: {
                        return List.of(PackageRecipeCategory.TYPE);
                    }
                }
            }
        }
        return List.of();
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        Object object = focus.getTypedValue().getIngredient();
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            RecipeType type = recipeCategory.getRecipeType();
            Item item = stack.m_41720_();
            if (item instanceof IPackageItem) {
                IPackageItem packageItem = (IPackageItem)item;
                IPackageRecipeInfo recipe = packageItem.getRecipeInfo(stack);
                int index = packageItem.getIndex(stack);
                if (recipe != null && recipe.validPatternIndex(index)) {
                    if (PackageRecipeCategory.TYPE.equals((Object)type) || PackageProcessingCategory.TYPE.equals((Object)type)) {
                        return List.of(recipe);
                    }
                    if (PackagingCategory.TYPE.equals((Object)type) || PackageContentsCategory.TYPE.equals((Object)type)) {
                        return List.of(recipe.getPatterns().get(index));
                    }
                }
            }
            if ((item = stack.m_41720_()) instanceof IPackageRecipeListItem) {
                IPackageRecipeListItem recipeListItem = (IPackageRecipeListItem)item;
                if (PackageRecipeCategory.TYPE.equals((Object)type) || PackageProcessingCategory.TYPE.equals((Object)type)) {
                    return recipeListItem.getRecipeList((Level)Minecraft.m_91087_().f_91073_, stack).getRecipeList();
                }
            }
        }
        return List.of();
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return List.of();
    }
}

