/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.blockentity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.crafting.IPatternDetails;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.block.PackagingProviderBlock;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.PackagerExtensionBlockEntity;
import thelm.packagedauto.block.entity.PackagingProviderBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.integration.appeng.AppEngUtil;
import thelm.packagedauto.integration.appeng.recipe.DirectCraftingPatternDetails;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternDetails;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternDetails;
import thelm.packagedauto.util.MiscHelper;

public class AEPackagingProviderBlockEntity
extends PackagingProviderBlockEntity
implements IInWorldGridNodeHost,
IGridNodeListener<AEPackagingProviderBlockEntity>,
IActionHost,
ICraftingProvider {
    public boolean firstTick = true;
    public IActionSource source = IActionSource.ofMachine((IActionHost)this);
    public IManagedGridNode gridNode;

    public AEPackagingProviderBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.getMainNode().create(this.f_58857_, this.f_58858_);
            this.postPatternChange();
        }
        super.tick();
        if (this.currentPattern != null) {
            this.sendPackaging();
        }
        if (!this.toSend.isEmpty()) {
            this.sendUnpackaging();
        }
    }

    protected void sendPackaging() {
        if (this.currentPattern == null) {
            return;
        }
        if (this.getMainNode().isActive()) {
            AEItemKey key;
            MEStorage inventory;
            IGrid grid = this.getMainNode().getGrid();
            IStorageService storageService = grid.getStorageService();
            IEnergyService energyService = grid.getEnergyService();
            int inserted = (int)StorageHelper.poweredInsert((IEnergySource)energyService, (MEStorage)(inventory = storageService.getInventory()), (AEKey)(key = AEItemKey.of((ItemStack)this.currentPattern.getOutput())), (long)1L, (IActionSource)this.source, (Actionable)Actionable.MODULATE);
            if (inserted == 1) {
                this.currentPattern = null;
            }
        }
    }

    protected void sendUnpackaging() {
        if (this.toSend.isEmpty()) {
            return;
        }
        if (this.sendDirection != null) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(this.sendDirection));
            if (!this.validSendTarget(blockEntity, this.sendDirection.m_122424_())) {
                this.sendDirection = null;
                return;
            }
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, this.sendDirection.m_122424_()).orElse(null);
            for (int i = 0; i < this.toSend.size(); ++i) {
                IVolumePackageItem vPackage;
                ItemStack stack;
                ItemStack stackRem = stack = (ItemStack)this.toSend.get(i);
                Item item = stack.m_41720_();
                if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity, this.sendDirection.m_122424_())) {
                    stackRem = MiscHelper.INSTANCE.fillVolume(blockEntity, this.sendDirection.m_122424_(), stack, false);
                } else if (itemHandler != null) {
                    stackRem = MiscHelper.INSTANCE.insertItem(itemHandler, stack, this.sendOrdered, false);
                }
                this.toSend.set(i, stackRem);
            }
            this.toSend.removeIf(ItemStack::m_41619_);
            this.m_6596_();
        } else if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IStorageService storageService = grid.getStorageService();
            IEnergyService energyService = grid.getEnergyService();
            MEStorage inventory = storageService.getInventory();
            for (int i = 0; i < this.toSend.size(); ++i) {
                int count;
                ItemStack is = (ItemStack)this.toSend.get(i);
                if (is.m_41619_()) continue;
                AEItemKey key = AEItemKey.of((ItemStack)is);
                int inserted = (int)StorageHelper.poweredInsert((IEnergySource)energyService, (MEStorage)inventory, (AEKey)key, (long)(count = is.m_41613_()), (IActionSource)this.source, (Actionable)Actionable.MODULATE);
                if (inserted == count) {
                    this.toSend.set(i, ItemStack.f_41583_);
                    continue;
                }
                this.toSend.set(i, key.toStack(count - inserted));
            }
            this.toSend.removeIf(ItemStack::m_41619_);
            this.m_6596_();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(Direction dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onSaveChanges(AEPackagingProviderBlockEntity nodeOwner, IGridNode node) {
        this.m_6596_();
    }

    public IManagedGridNode getMainNode() {
        if (this.gridNode == null) {
            this.gridNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)this);
            this.gridNode.setTagName("Node");
            this.gridNode.setVisualRepresentation((ItemLike)PackagingProviderBlock.INSTANCE);
            this.gridNode.setGridColor(AEColor.TRANSPARENT);
            this.gridNode.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.gridNode.addService(ICraftingProvider.class, (IGridNodeService)this);
            this.gridNode.setIdlePowerUsage(1.0);
            this.gridNode.setInWorldNode(true);
            if (this.ownerUUID != null && this.f_58857_ instanceof ServerLevel) {
                this.gridNode.setOwningPlayerId(IPlayerRegistry.getMapping((Level)this.f_58857_).getPlayerId(this.ownerUUID));
            }
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getMainNode().getNode();
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (this.getMainNode().isActive() && !this.isBusy()) {
            IGrid grid = this.getMainNode().getGrid();
            IEnergyService energyService = grid.getEnergyService();
            double conversion = PowerUnits.FE.convertTo(PowerUnits.AE, 1.0);
            IPackageRecipeInfo recipe = null;
            if (patternDetails instanceof DirectCraftingPatternDetails) {
                DirectCraftingPatternDetails pattern = (DirectCraftingPatternDetails)patternDetails;
                recipe = pattern.recipe;
            } else if (patternDetails instanceof RecipeCraftingPatternDetails) {
                RecipeCraftingPatternDetails pattern = (RecipeCraftingPatternDetails)patternDetails;
                recipe = pattern.recipe;
            } else if (patternDetails instanceof PackageCraftingPatternDetails) {
                PackageCraftingPatternDetails pattern = (PackageCraftingPatternDetails)patternDetails;
                double request = (double)(PackagerBlockEntity.energyReq * 2) * conversion;
                if (request - energyService.extractAEPower(request, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4) {
                    return false;
                }
                this.currentPattern = pattern.pattern;
                return true;
            }
            if (recipe != null) {
                double request = (double)(PackagerBlockEntity.energyReq * 2 + UnpackagerBlockEntity.energyUsage) * conversion;
                if (request - energyService.extractAEPower(request, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4) {
                    return false;
                }
                if (recipe.getRecipeType().hasMachine()) {
                    for (Direction direction : Direction.values()) {
                        IPackageCraftingMachine machine;
                        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                        if (!(blockEntity instanceof IPackageCraftingMachine) || (machine = (IPackageCraftingMachine)blockEntity).isBusy() || !machine.acceptPackage(recipe, Lists.transform(recipe.getInputs(), ItemStack::m_41777_), direction.m_122424_())) continue;
                        energyService.extractAEPower(request, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                        return true;
                    }
                    return false;
                }
                ArrayList toSend = new ArrayList();
                recipe.getInputs().stream().map(ItemStack::m_41777_).forEach(toSend::add);
                block1: for (Direction direction : Direction.values()) {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                    if (!this.validSendTarget(blockEntity, direction.m_122424_())) continue;
                    IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse(null);
                    if (this.blocking) {
                        for (int i = 0; i < toSend.size(); ++i) {
                            IVolumePackageItem vPackage;
                            ItemStack stack = (ItemStack)toSend.get(i);
                            Item item = stack.m_41720_();
                            if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity, direction.m_122424_()) ? !vPackage.getVolumeType(stack).isEmpty((ICapabilityProvider)blockEntity, direction.m_122424_()) : itemHandler != null && !MiscHelper.INSTANCE.isEmpty(itemHandler)) continue block1;
                        }
                    }
                    boolean acceptsAll = true;
                    for (int i = 0; i < toSend.size(); ++i) {
                        IVolumePackageItem vPackage;
                        ItemStack stack;
                        ItemStack stackRem = stack = (ItemStack)toSend.get(i);
                        Item item = stack.m_41720_();
                        if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity, direction.m_122424_())) {
                            stackRem = MiscHelper.INSTANCE.fillVolume(blockEntity, direction.m_122424_(), stack, true);
                        } else if (itemHandler != null) {
                            stackRem = MiscHelper.INSTANCE.insertItem(itemHandler, stack, false, true);
                        }
                        acceptsAll &= stackRem.m_41613_() < stack.m_41613_();
                    }
                    if (!acceptsAll) continue;
                    this.sendDirection = direction;
                    this.toSend.addAll(toSend);
                    this.sendOrdered = recipe.getRecipeType().isOrdered();
                    this.sendUnpackaging();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected boolean validSendTarget(BlockEntity blockEntity, Direction direction) {
        return blockEntity != null && !(blockEntity instanceof PackagerBlockEntity) && !(blockEntity instanceof PackagerExtensionBlockEntity) && !(blockEntity instanceof UnpackagerBlockEntity) && !AppEngUtil.isPatternProvider(blockEntity, direction);
    }

    public boolean isBusy() {
        return this.powered || this.currentPattern != null || !this.toSend.isEmpty();
    }

    public List<IPatternDetails> getAvailablePatterns() {
        ArrayList<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
        if (this.provideDirect) {
            this.recipeList.stream().filter(pattern -> !pattern.getOutputs().isEmpty()).map(pattern -> new DirectCraftingPatternDetails((IPackageRecipeInfo)pattern)).forEach(patterns::add);
        }
        if (this.providePackaging) {
            this.recipeList.stream().filter(IPackageRecipeInfo::isValid).flatMap(recipe -> Streams.concat((Stream[])new Stream[]{recipe.getPatterns().stream(), recipe.getExtraPatterns().stream()})).map(pattern -> new PackageCraftingPatternDetails((IPackagePattern)pattern)).forEach(patterns::add);
        }
        if (this.provideUnpackaging) {
            this.recipeList.stream().filter(pattern -> !pattern.getOutputs().isEmpty()).map(pattern -> new RecipeCraftingPatternDetails((IPackageRecipeInfo)pattern)).forEach(patterns::add);
        }
        return patterns;
    }

    @Override
    public void postPatternChange() {
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("Node")) {
            this.getMainNode().loadFromNBT(nbt);
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT(nbt);
        }
    }
}

