/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.energy;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.network.packet.SyncEnergyPacket;

public class EnergyStorage
extends net.minecraftforge.energy.EnergyStorage {
    public final BaseBlockEntity blockEntity;
    public int prevEnergy;

    public EnergyStorage(BaseBlockEntity blockEntity, int capacity) {
        this(blockEntity, capacity, capacity, capacity, 0);
    }

    public EnergyStorage(BaseBlockEntity blockEntity, int capacity, int maxTransfer) {
        this(blockEntity, capacity, maxTransfer, maxTransfer, 0);
    }

    public EnergyStorage(BaseBlockEntity blockEntity, int capacity, int maxReceive, int maxExtract) {
        this(blockEntity, capacity, maxReceive, maxExtract, 0);
    }

    public EnergyStorage(BaseBlockEntity blockEntity, int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
        this.blockEntity = blockEntity;
    }

    public EnergyStorage read(CompoundTag nbt) {
        this.energy = nbt.m_128451_("Energy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    public void save(CompoundTag nbt) {
        if (this.energy < 0) {
            this.energy = 0;
        }
        nbt.m_128405_("Energy", this.energy);
    }

    public EnergyStorage setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
        return this;
    }

    public EnergyStorage setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public EnergyStorage setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public EnergyStorage setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public void modifyEnergyStored(int energy) {
        this.energy += energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public void updateIfChanged() {
        int currentEnergy = this.getEnergyStored();
        if (!this.blockEntity.m_58904_().f_46443_ && this.prevEnergy != currentEnergy) {
            SyncEnergyPacket.syncEnergy(this.blockEntity.m_58899_(), currentEnergy, (ResourceKey<Level>)this.blockEntity.m_58904_().m_46472_(), 8.0);
            this.blockEntity.m_6596_();
        }
        this.prevEnergy = currentEnergy;
    }
}

