/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation.data;

import igentuman.nc.NuclearCraft;
import igentuman.nc.compat.mekanism.MekanismRadiation;
import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.network.toClient.PacketPlayerRadiationData;
import igentuman.nc.network.toClient.PacketWorldRadiationData;
import igentuman.nc.radiation.data.PlayerRadiation;
import igentuman.nc.radiation.data.PlayerRadiationProvider;
import igentuman.nc.radiation.data.WorldRadiation;
import igentuman.nc.util.ModUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class RadiationManager
extends SavedData {
    private WorldRadiation worldRadiation;
    private int tickCounter;
    protected int[] ignoredPos;

    public static void clear(Level level) {
        RadiationManager.get((Level)level).worldRadiation.chunkRadiation.clear();
        RadiationManager.get((Level)level).worldRadiation.updatedChunks.clear();
    }

    public WorldRadiation getWorldRadiation() {
        return this.worldRadiation;
    }

    public void setWorldRadiation(WorldRadiation worldRadiation) {
        this.worldRadiation = worldRadiation;
        this.m_77762_();
    }

    public RadiationManager() {
        this.tickCounter = (Integer)RadiationConfig.RADIATION_CONFIG.RADIATION_UPDATE_INTERVAL.get();
        this.worldRadiation = new WorldRadiation();
    }

    @Nonnull
    public static RadiationManager get(Level level) {
        if (level.f_46443_) {
            throw new RuntimeException("Don't access this client-side!");
        }
        DimensionDataStorage storage = ((ServerLevel)level).m_8895_();
        return (RadiationManager)storage.m_164861_(RadiationManager::new, RadiationManager::new, "nc_world_radiation");
    }

    public void tick(Level level) {
        if (!((Boolean)RadiationConfig.RADIATION_CONFIG.ENABLED.get()).booleanValue()) {
            return;
        }
        level.m_6907_().forEach(player -> {
            long wasRadiation = 0L;
            long playerRadiation = 0L;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (serverPlayer.m_5833_() || serverPlayer.m_7500_()) {
                    return;
                }
                int playerChunkX = player.m_146902_().f_45578_;
                int playerChunkZ = player.m_146902_().f_45579_;
                long id = WorldRadiation.pack(playerChunkX, playerChunkZ);
                PlayerRadiation playerRadiationCap = (PlayerRadiation)serverPlayer.getCapability(PlayerRadiationProvider.PLAYER_RADIATION).orElse(null);
                if (playerRadiationCap != null) {
                    wasRadiation = playerRadiationCap.getRadiation();
                    playerRadiationCap.updateRadiation(level, (LivingEntity)player);
                    playerRadiation = playerRadiationCap.getRadiation();
                }
                if (this.worldRadiation.chunkRadiation.get(id) != null) {
                    NuclearCraft.packetHandler().sendTo(new PacketWorldRadiationData(id, this.worldRadiation.chunkRadiation.get(id)), serverPlayer);
                } else if (wasRadiation != playerRadiation) {
                    NuclearCraft.packetHandler().sendTo(new PacketPlayerRadiationData(playerRadiation), serverPlayer);
                }
            }
        });
        --this.tickCounter;
        if (this.tickCounter == (Integer)RadiationConfig.RADIATION_CONFIG.RADIATION_UPDATE_INTERVAL.get() / 2) {
            this.worldRadiation.refresh(level);
            return;
        }
        if (this.tickCounter == 0) {
            this.tickCounter = (Integer)RadiationConfig.RADIATION_CONFIG.RADIATION_UPDATE_INTERVAL.get();
            if (this.worldRadiation.updatedChunks.isEmpty()) {
                return;
            }
            this.m_77762_();
        }
    }

    public RadiationManager(CompoundTag tag) {
        this.tickCounter = (Integer)RadiationConfig.RADIATION_CONFIG.RADIATION_UPDATE_INTERVAL.get();
        this.worldRadiation = tag.m_128441_("radiation") ? WorldRadiation.deserialize(tag) : new WorldRadiation();
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        return this.worldRadiation.serializeNBT();
    }

    public void addRadiation(Level level, double value, int x, int y, int z) {
        if (!((Boolean)RadiationConfig.RADIATION_CONFIG.ENABLED.get()).booleanValue()) {
            return;
        }
        if (this.ignoredPos != null && this.ignoredPos[0] == x && this.ignoredPos[1] == y && this.ignoredPos[2] == z) {
            this.ignoredPos = null;
            return;
        }
        LevelChunk chunk = level.m_46745_(new BlockPos(x, y, z));
        int appliedRadiation = this.worldRadiation.addRadiation(level, value, chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        if (ModUtil.isMekanismLoadeed() && ((Boolean)RadiationConfig.RADIATION_CONFIG.MEKANISM_RADIATION_INTEGRATION.get()).booleanValue()) {
            this.ignoredPos = new int[]{x, y, z};
            MekanismRadiation.radiate(x, y, z, appliedRadiation / 1000, level);
        }
    }
}

