/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation.client;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.client.NcClient;
import igentuman.nc.radiation.client.ClientRadiationData;
import igentuman.nc.radiation.data.PlayerRadiation;
import igentuman.nc.setup.registration.NCItems;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class RadiationOverlay {
    private static final ResourceLocation RADIATION_BAR_TEXTURE = new ResourceLocation("nuclearcraft", "textures/gui/overlay/radiation_bar.png");
    public static final IGuiOverlay RADIATION_BAR = (gui, poseStack, partialTicks, width, height) -> {
        Player pl = NcClient.tryGetClientPlayer();
        if (pl == null) {
            return;
        }
        if (!RadiationOverlay.hasDosimeter(pl)) {
            return;
        }
        long radiation = ClientRadiationData.getPlayerRadiation();
        String toDisplay = String.valueOf(radiation);
        int x = width / 2;
        int y = height;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RADIATION_BAR_TEXTURE);
        poseStack.m_280163_(RADIATION_BAR_TEXTURE, 4, y - 15, 0.0f, 0.0f, 94, 11, 256, 256);
        int maxRadiationBar = PlayerRadiation.maxPlayerRadiation;
        int barWidth = (int)Math.min(128L, radiation * 90L / (long)maxRadiationBar);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RADIATION_BAR_TEXTURE);
        poseStack.m_280163_(RADIATION_BAR_TEXTURE, 6, y - 13, 0.0f, 11.0f, barWidth, 8, 256, 256);
    };

    public static boolean hasDosimeter(Player player) {
        return player.m_150109_().m_36063_(new ItemStack((ItemLike)NCItems.ALL_NC_ITEMS.get("dosimeter").get()));
    }
}

