/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation;

import igentuman.nc.handler.config.RadiationConfig;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class RadiationCleaningItems {
    protected static HashMap<Item, Long> radiationMap = new HashMap();
    protected static boolean initialized = false;

    public static HashMap<Item, Long> get() {
        return radiationMap;
    }

    public static void init() {
        if (!radiationMap.isEmpty()) {
            return;
        }
        for (String line : (List)RadiationConfig.RADIATION_CONFIG.RADIATION_REMOVAL_ITEMS.get()) {
            Item item;
            String[] split = line.split("\\|");
            if (split.length != 2 || (item = RadiationCleaningItems.getItemByName(split[0].trim())).equals(Items.f_41852_)) continue;
            try {
                radiationMap.put(item, Long.parseLong(split[1].trim()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static void add(String item, long radiation) {
        Item toAdd = RadiationCleaningItems.getItemByName(item);
        if (toAdd.equals(Items.f_41852_)) {
            return;
        }
        radiationMap.put(toAdd, radiation);
    }

    public static void add(Item item, long radiation) {
        radiationMap.put(item, radiation);
    }

    protected static Item getItemByName(String name) {
        if (!((String)name).contains(":")) {
            name = "nuclearcraft:" + (String)name;
        }
        ResourceLocation itemKey = new ResourceLocation(((String)name).replace("/", "_"));
        return (Item)ForgeRegistries.ITEMS.getValue(itemKey);
    }

    public static long byItem(Item item) {
        if (!initialized) {
            RadiationCleaningItems.init();
            initialized = true;
        }
        if (radiationMap.containsKey(item)) {
            return radiationMap.get(item);
        }
        return 0L;
    }
}

