/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock;

import igentuman.nc.multiblock.IMultiblockAttachable;
import igentuman.nc.multiblock.INCMultiblock;
import igentuman.nc.multiblock.INCMultiblockController;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.util.NCBlockPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractNCMultiblock
implements INCMultiblock {
    public boolean hasToRefresh = true;
    protected int refreshCooldown = 50;
    protected int height;
    protected int width;
    protected int depth;
    protected INCMultiblockController controller;
    public ValidationResult validationResult;
    public String id;
    public int topCasing = 0;
    public int bottomCasing = 0;
    public int leftCasing = 0;
    public int rightCasing = 0;
    private NCBlockPos bottomLeft;
    private NCBlockPos topRight;
    protected boolean outerValid = false;
    public boolean refreshOuterCacheFlag = true;
    public boolean refreshInnerCacheFlag = true;
    public boolean isFormed = false;
    protected boolean innerValid = false;
    protected final List<Block> validOuterBlocks;
    protected final List<Block> validInnerBlocks;
    protected List<BlockPos> controllers = new ArrayList<BlockPos>();
    protected HashMap<Long, BlockEntity> beCache = new HashMap();
    protected HashMap<Long, BlockState> bsCache = new HashMap();
    protected List<BlockPos> allBlocks = new ArrayList<BlockPos>();
    protected BlockPos controllerPos;

    protected AbstractNCMultiblock(List<Block> validOuterBlocks, List<Block> validInnerBlocks) {
        this.validOuterBlocks = validOuterBlocks;
        this.validInnerBlocks = validInnerBlocks;
    }

    public void dispose() {
        MultiblockHandler.removeMultiblock(this);
    }

    public List<Block> validCornerBlocks() {
        return this.validOuterBlocks;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public int maxHeight() {
        return 24;
    }

    @Override
    public int minHeight() {
        return 3;
    }

    @Override
    public int maxWidth() {
        return 24;
    }

    @Override
    public int minWidth() {
        return 3;
    }

    @Override
    public int maxDepth() {
        return 24;
    }

    @Override
    public int minDepth() {
        return 3;
    }

    @Override
    public boolean isFormed() {
        return this.isFormed;
    }

    @Override
    public List<Block> validOuterBlocks() {
        return this.validOuterBlocks;
    }

    @Override
    public List<Block> validInnerBlocks() {
        return this.validInnerBlocks;
    }

    protected Level getLevel() {
        return this.controller().controllerBE().m_58904_();
    }

    protected BlockPos controllerPos() {
        if (this.controllerPos == null) {
            this.controllerPos = this.controller().controllerBE().m_58899_();
        }
        return NCBlockPos.of(this.controllerPos);
    }

    public BlockPos getBottomLeftBlock() {
        if (this.controllerPos instanceof NCBlockPos) {
            ((NCBlockPos)this.controllerPos).revert();
        }
        return this.getLeftPos(this.leftCasing).m_6625_(this.bottomCasing).m_5484_(this.getFacing(), -this.depth + 1);
    }

    public BlockPos getBottomLeftInnerBlock() {
        if (this.controllerPos instanceof NCBlockPos) {
            ((NCBlockPos)this.controllerPos).revert();
        }
        return new BlockPos((Vec3i)this.getLeftPos(this.leftCasing - 1).m_6625_(this.bottomCasing - 1).m_5484_(this.getFacing(), -this.depth + 2));
    }

    public BlockPos getTopRightBlock() {
        if (this.controllerPos instanceof NCBlockPos) {
            ((NCBlockPos)this.controllerPos).revert();
        }
        return this.getRightPos(this.rightCasing).m_6630_(this.topCasing);
    }

    public BlockPos getTopRightInnerBlock() {
        if (this.controllerPos instanceof NCBlockPos) {
            ((NCBlockPos)this.controllerPos).revert();
        }
        return new BlockPos((Vec3i)this.getRightPos(this.rightCasing - 1).m_6630_(this.topCasing - 1).m_5484_(this.getFacing(), -1));
    }

    public BlockPos getCenterBlock() {
        BlockPos bottomLeft = this.getBottomLeftBlock();
        BlockPos topRight = this.getTopRightBlock();
        return new BlockPos((bottomLeft.m_123341_() + topRight.m_123341_()) / 2, (bottomLeft.m_123342_() + topRight.m_123342_()) / 2, (bottomLeft.m_123343_() + topRight.m_123343_()) / 2);
    }

    protected BlockState getBlockState(BlockPos pos) {
        if (this.bsCache.containsKey(pos.m_121878_())) {
            return this.bsCache.get(pos.m_121878_());
        }
        BlockState state = this.getLevel().m_8055_(pos);
        this.bsCache.put(pos.m_121878_(), state);
        return state;
    }

    public boolean isValidForOuter(BlockPos pos) {
        if (this.getLevel() == null) {
            return false;
        }
        try {
            return this.validOuterBlocks().contains(this.getBlockState(pos).m_60734_());
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean isValidCorner(BlockPos pos) {
        if (this.getLevel() == null) {
            return false;
        }
        try {
            return this.validCornerBlocks().contains(this.getBlockState(pos).m_60734_());
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean isValidForInner(BlockPos pos) {
        if (this.getLevel() == null) {
            return false;
        }
        try {
            BlockState bs = this.getBlockState(pos);
            if (bs.m_60795_()) {
                return true;
            }
            return this.validInnerBlocks().contains(bs.m_60734_());
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public int resolveHeight() {
        int i;
        for (i = 1; i < this.maxHeight(); ++i) {
            if (this.isValidForOuter(this.controllerPos().m_6630_(i))) continue;
            this.topCasing = i - 1;
            this.height = i;
            break;
        }
        for (i = 1; i < this.maxHeight(); ++i) {
            if (this.isValidForOuter(this.controllerPos().m_6625_(i))) continue;
            this.bottomCasing = i - 1;
            this.height += i - 1;
            break;
        }
        return this.height;
    }

    public int resolveWidth() {
        int i;
        for (i = 1; i < this.maxWidth(); ++i) {
            if (this.isValidForOuter(this.getLeftPos(i))) continue;
            this.leftCasing = i - 1;
            this.width = i;
            break;
        }
        for (i = 1; i < this.maxWidth(); ++i) {
            if (this.isValidForOuter(this.getRightPos(i))) continue;
            this.rightCasing = i - 1;
            this.width += i - 1;
            break;
        }
        return this.width;
    }

    public int resolveDepth() {
        for (int i = 1; i < this.maxDepth(); ++i) {
            if (this.isValidForOuter(this.getForwardPos(i).m_6630_(this.topCasing))) continue;
            this.depth = i;
            break;
        }
        return this.depth;
    }

    public void resolveDimensions() {
        if (this.getFacing() == null) {
            return;
        }
        this.resolveHeight();
        this.resolveDepth();
        this.resolveWidth();
    }

    @Override
    public void validateOuter() {
        this.resolveDimensions();
        if (this.width < this.minWidth() || this.height < this.minHeight() || this.depth < this.minDepth()) {
            this.validationResult = ValidationResult.TOO_SMALL;
            return;
        }
        if (this.width > this.maxWidth() || this.height > this.maxHeight() || this.depth > this.maxDepth()) {
            this.validationResult = ValidationResult.TOO_BIG;
            return;
        }
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    if (y != 0 && x != 0 && z != 0 && y != this.height - 1 && x != this.width - 1 && z != this.depth - 1) continue;
                    if (!this.isValidForOuter(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getFacing(), -z))) {
                        this.validationResult = ValidationResult.WRONG_OUTER;
                        this.controller().addErroredBlock(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getFacing(), -z));
                        return;
                    }
                    this.processOuterBlock(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getFacing(), -z));
                    if ((y != 0 && y != this.height - 1 || z != 0 && z != this.depth - 1) && (y != 0 && y != this.height - 1 || x != 0 && x != this.width - 1) && (z != 0 && z != this.depth - 1 || x != 0 && x != this.width - 1) || this.isValidCorner(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getFacing(), -z))) continue;
                    this.validationResult = ValidationResult.WRONG_CORNER;
                    this.controller().addErroredBlock(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getFacing(), -z));
                    return;
                }
            }
        }
        if (this.controllers.size() > 1) {
            this.validationResult = ValidationResult.TOO_MANY_CONTROLLERS;
            return;
        }
        this.validationResult = ValidationResult.VALID;
    }

    protected void updateDimensions(BlockPos pos) {
        if (this.topRight == null) {
            this.topRight = new NCBlockPos((Vec3i)pos);
        }
        if (this.bottomLeft == null) {
            this.bottomLeft = new NCBlockPos((Vec3i)pos);
        }
        if (pos.m_123341_() <= this.bottomLeft.m_123341_() && pos.m_123342_() <= this.bottomLeft.m_123342_() && pos.m_123343_() <= this.bottomLeft.m_123343_()) {
            this.bottomLeft.x(pos.m_123341_());
            this.bottomLeft.y(pos.m_123342_());
            this.bottomLeft.z(pos.m_123343_());
        }
        if (pos.m_123341_() >= this.topRight.m_123341_() && pos.m_123342_() >= this.topRight.m_123342_() && pos.m_123343_() >= this.topRight.m_123343_()) {
            this.topRight.x(pos.m_123341_());
            this.topRight.y(pos.m_123342_());
            this.topRight.z(pos.m_123343_());
        }
    }

    protected void processOuterBlock(BlockPos pos) {
        this.attachMultiblock(pos);
        this.updateDimensions(pos);
        this.allBlocks.add(new BlockPos((Vec3i)pos));
        if (this.getBlockState(pos).m_60734_().m_5456_().toString().contains("controller")) {
            this.controllers.add(pos);
        }
    }

    @Override
    public void validateInner() {
        this.invalidateStats();
        if (!this.outerValid) {
            return;
        }
        for (int y = 1; y < this.resolveHeight() - 1; ++y) {
            for (int x = 1; x < this.resolveWidth() - 1; ++x) {
                for (int z = 1; z < this.resolveDepth() - 1; ++z) {
                    NCBlockPos toCheck = new NCBlockPos((Vec3i)this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getFacing(), -z));
                    if (!this.isValidForInner(toCheck)) {
                        this.validationResult = ValidationResult.WRONG_INNER;
                        this.controller().addErroredBlock(toCheck);
                        return;
                    }
                    this.processInnerBlock(toCheck.copy());
                }
            }
        }
        this.validationResult = ValidationResult.VALID;
    }

    protected boolean processInnerBlock(BlockPos toCheck) {
        this.allBlocks.add(new BlockPos((Vec3i)toCheck));
        this.attachMultiblock(toCheck);
        return true;
    }

    protected abstract void invalidateStats();

    protected void attachMultiblock(BlockPos pos) {
        this.attachMultiblock(this.getBlockEntity(pos));
    }

    protected BlockEntity getBlockEntity(BlockPos pos) {
        if (this.beCache.containsKey(pos.m_121878_())) {
            return this.beCache.get(pos.m_121878_());
        }
        BlockEntity be = this.getLevel().m_7702_(pos);
        this.beCache.put(pos.m_121878_(), be);
        return be;
    }

    protected void attachMultiblock(BlockEntity be) {
        if (be instanceof IMultiblockAttachable) {
            IMultiblockAttachable part = (IMultiblockAttachable)be;
            part.setMultiblock(this);
        }
    }

    public boolean isLoaded(BlockPos pos) {
        return this.getLevel().m_46749_(pos);
    }

    public void onControllerRemoved() {
        for (BlockPos b : this.allBlocks) {
            BlockEntity be;
            if (!this.isLoaded(b) || !((be = this.getBlockEntity(b)) instanceof IMultiblockAttachable)) continue;
            ((IMultiblockAttachable)be).setMultiblock(null);
        }
        this.dispose();
    }

    public BlockPos getForwardPos(int i) {
        return this.controllerPos().m_5484_(this.getFacing(), -i);
    }

    public BlockPos getLeftPos(int i) {
        return this.getSidePos(-i);
    }

    public BlockPos getRightPos(int i) {
        return this.getSidePos(i);
    }

    public BlockPos getSidePos(int i) {
        return switch (this.getFacing().ordinal()) {
            case 3 -> this.controllerPos().m_122030_(i);
            case 5 -> this.controllerPos().m_122013_(i);
            case 2 -> this.controllerPos().m_122025_(i);
            case 4 -> this.controllerPos().m_122020_(i);
            default -> null;
        };
    }

    protected abstract Direction getFacing();

    @Override
    public void validate() {
        this.topRight = null;
        this.bottomLeft = null;
        this.validationResult = ValidationResult.INCOMPLETE;
        this.refreshOuterCacheFlag = true;
        this.refreshInnerCacheFlag = true;
        this.allBlocks.clear();
        this.controllers.clear();
        this.bsCache.clear();
        this.beCache.clear();
        if (this.isOuterValid()) {
            this.validateInner();
        }
        this.innerValid = this.validationResult.isValid;
        boolean bl = this.isFormed = this.outerValid && this.innerValid;
        if (this.isFormed) {
            this.validationResult = ValidationResult.VALID;
        }
    }

    @Override
    public boolean isInnerValid() {
        if (this.refreshOuterCacheFlag) {
            return false;
        }
        if (this.refreshInnerCacheFlag) {
            this.validateInner();
            this.refreshInnerCacheFlag = !this.validationResult.isValid;
            this.innerValid = this.validationResult.isValid;
        }
        return this.innerValid;
    }

    @Override
    public boolean isOuterValid() {
        if (this.refreshOuterCacheFlag) {
            this.validateOuter();
            this.refreshOuterCacheFlag = !this.validationResult.isValid;
            this.outerValid = this.validationResult.isValid;
        }
        return this.outerValid;
    }

    @Override
    public INCMultiblockController controller() {
        return this.controller;
    }

    public void onNeighborChange(BlockState state, BlockPos pos, BlockPos neighbor) {
        if (this.shouldRefreshCache(state, pos, neighbor)) {
            this.hasToRefresh = true;
        }
    }

    private boolean shouldRefreshCache(BlockState state, BlockPos pos, BlockPos neighbor) {
        boolean isInTheList = this.allBlocks.contains(neighbor);
        BlockEntity neighborBe = this.getBlockEntity(neighbor);
        if (!isInTheList) {
            return false;
        }
        if (neighborBe instanceof IMultiblockAttachable) {
            IMultiblockAttachable part = (IMultiblockAttachable)neighborBe;
            return part.canInvalidateCache();
        }
        return true;
    }

    public void tick() {
        if (this.hasToRefresh) {
            --this.refreshCooldown;
            if (this.refreshCooldown <= 0) {
                this.refreshOuterCacheFlag = true;
                this.refreshInnerCacheFlag = true;
                this.validationResult = ValidationResult.INCOMPLETE;
                this.innerValid = false;
                this.outerValid = false;
                this.isFormed = false;
                this.hasToRefresh = false;
                this.beCache = new HashMap();
                this.bsCache = new HashMap();
                this.refreshCooldown = 20;
            }
        }
    }

    public void onBlockDestroyed(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        this.controller.clearStats();
    }

    public boolean onBlockChange(BlockPos pos) {
        if (this.allBlocks.contains(pos)) {
            Block targetBlock = this.getBlockState(pos).m_60734_();
            if (targetBlock.m_7705_().matches(".*fusion_proxy.*|.*fusion_core.*|.*controller.*|.*port.*|.*irradiator.*")) {
                return true;
            }
            this.hasToRefresh = true;
            this.controller.clearStats();
            return true;
        }
        this.resolveDimensions();
        if (this.bottomLeft == null || this.topRight == null) {
            return false;
        }
        if (pos.m_123341_() >= this.bottomLeft.m_123341_() && pos.m_123342_() >= this.bottomLeft.m_123342_() && pos.m_123343_() >= this.bottomLeft.m_123343_() && pos.m_123341_() <= this.topRight.m_123341_() && pos.m_123342_() <= this.topRight.m_123342_() && pos.m_123343_() <= this.topRight.m_123343_()) {
            Block targetBlock = this.getBlockState(pos).m_60734_();
            if (targetBlock.m_7705_().matches(".*core_proxy.*|.*fusion_core.*|.*port.*|.*irradiator.*")) {
                return true;
            }
            this.hasToRefresh = true;
            this.controller.clearStats();
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public boolean checkAttachmentToBlock(Class<?> toCheck, Level level, BlockPos pos, Direction dir) {
        return false;
    }

    public boolean isLoaded() {
        if (this.controllerPos == null) {
            return false;
        }
        return this.getLevel().m_7726_().m_5563_(this.controllerPos.m_123341_() >> 4, this.controllerPos.m_123343_() >> 4);
    }
}

