/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.sided;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class SlotModePair {
    private SlotMode slotMode;
    private final int slot;

    public SlotModePair(SlotMode slotMode, int slot) {
        this.slotMode = slotMode;
        this.slot = slot;
    }

    public SlotModePair(int slotMode, int slot) {
        this.slotMode = SlotMode.values()[slotMode];
        this.slot = slot;
    }

    public static Tag serializeArray(SlotModePair[] slotModePairs) {
        CompoundTag tag = new CompoundTag();
        int[] vals = new int[slotModePairs.length];
        for (int i = 0; i < slotModePairs.length; ++i) {
            vals[i] = slotModePairs[i].pack();
        }
        tag.m_128385_("pairs", vals);
        return tag;
    }

    public static SlotModePair[] deserializeArray(CompoundTag compound) {
        int[] vals = compound.m_128465_("pairs");
        SlotModePair[] slotModePairs = new SlotModePair[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            slotModePairs[i] = SlotModePair.unpack(vals[i]);
        }
        return slotModePairs;
    }

    public SlotMode getMode() {
        return this.slotMode;
    }

    public int getSlot() {
        return this.slot;
    }

    public int pack() {
        return this.slotMode.ordinal() * 100 + this.slot;
    }

    public static SlotModePair unpack(int packedValue) {
        int slotMode = packedValue / 100;
        int slot = packedValue % 100;
        return new SlotModePair(slotMode, slot);
    }

    public void setMode(SlotMode slotMode) {
        this.slotMode = slotMode;
    }

    public static enum SlotMode {
        DEFAULT(-2139062144),
        INPUT(-2147451905),
        PULL(-2144720695),
        OUTPUT(-2130740436),
        PUSH(-2134261960),
        PUSH_EXCESS(-2134302180),
        DISABLED(Integer.MIN_VALUE),
        UNKNOWN(-2130771968);

        private int color;

        private SlotMode(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }
    }
}

