/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.config;

import igentuman.nc.content.materials.Ores;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class OreGenConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final OresConfig ORE_CONFIG = new OresConfig(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static <T> List<T> toList(Collection<T> vals) {
        return new ArrayList<T>(vals);
    }

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class OresConfig {
        public HashMap<String, OreGenSpec> ORES = new HashMap();

        public OresConfig(ForgeConfigSpec.Builder builder) {
            for (String name : Ores.all().keySet()) {
                this.ORES.put(name, this.buildOreConfig(builder, name));
            }
        }

        private OreGenSpec buildOreConfig(ForgeConfigSpec.Builder builder, String name) {
            builder.push(name).comment("Ore generation settings for " + name);
            OreGenSpec oreGen = new OreGenSpec(builder, true, Ores.all().get((Object)name).dimensions, Ores.all().get((Object)name).veinSize, Ores.all().get((Object)name).height[0], Ores.all().get((Object)name).height[1]);
            builder.pop();
            return oreGen;
        }

        public static class OreGenSpec {
            public ForgeConfigSpec.ConfigValue<Boolean> register;
            public ForgeConfigSpec.ConfigValue<List<Integer>> dimensions;
            public ForgeConfigSpec.ConfigValue<Integer> veinSize;
            public ForgeConfigSpec.ConfigValue<Integer> min_height;
            public ForgeConfigSpec.ConfigValue<Integer> max_height;

            OreGenSpec(ForgeConfigSpec.Builder builder, boolean register, List<Integer> dimensions, int veinSize, int min_height, int max_height) {
                this.register = builder.define("register", register);
                this.dimensions = builder.define("dimensions", dimensions, o -> o instanceof ArrayList);
                this.veinSize = builder.defineInRange("vein_size", veinSize, 0, 64);
                this.min_height = builder.defineInRange("min_height", min_height, -64, 255);
                this.max_height = builder.defineInRange("max_height", max_height, -64, 255);
            }
        }
    }
}

