/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.storage;

import igentuman.nc.block.entity.ContainerBE;
import igentuman.nc.content.storage.ContainerBlocks;
import igentuman.nc.handler.config.CommonConfig;
import java.util.List;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ContainerBlockPrefab {
    private boolean registered = true;
    private boolean initialized = false;
    private String name;
    protected int rows = 0;
    protected int colls = 0;
    private BlockEntityType.BlockEntitySupplier<? extends BlockEntity> blockEntity;

    public ContainerBlockPrefab(String name, int rows, int colls) {
        this.rows = rows;
        this.colls = colls;
        this.blockEntity = ContainerBE::new;
        this.name = name;
    }

    public int getCapacity() {
        return this.rows * this.colls;
    }

    public ContainerBlockPrefab config() {
        if (!this.initialized) {
            int id = ContainerBlocks.all().keySet().stream().toList().indexOf(this.name);
            this.registered = (Boolean)((List)CommonConfig.STORAGE_BLOCKS.REGISTER_CONTAINER.get()).get(id);
            this.initialized = true;
        }
        return this;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public BlockEntityType.BlockEntitySupplier<? extends BlockEntity> getBlockEntity() {
        return this.blockEntity;
    }

    public ContainerBlockPrefab setBlockEntity(BlockEntityType.BlockEntitySupplier<? extends BlockEntity> blockEntity) {
        this.blockEntity = blockEntity;
        return this;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColls() {
        return this.colls;
    }
}

