/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.processors.config;

import java.util.ArrayList;
import java.util.List;

public class ProcessorSlots {
    public static int[] inputSlotPos = new int[]{31, 30};
    public static int[] outputSlotPos = new int[]{115, 30};
    public static int margin = 20;
    private int input_items;
    private int input_fluids;
    private int output_items;
    private int output_fluids;
    private List<int[]> slotPositions;

    public int getInputItems() {
        return this.input_items;
    }

    public ProcessorSlots setInputItems(int input_items) {
        this.input_items = input_items;
        return this;
    }

    public int getInputFluids() {
        return this.input_fluids;
    }

    public ProcessorSlots setInputFluids(int input_fluids) {
        this.input_fluids = input_fluids;
        return this;
    }

    public int getOutputItems() {
        return this.output_items;
    }

    public ProcessorSlots setOutputItems(int output_items) {
        this.output_items = output_items;
        return this;
    }

    public int getOutputFluids() {
        return this.output_fluids;
    }

    public ProcessorSlots setOutputFluids(int cnt) {
        this.output_fluids = cnt;
        return this;
    }

    public List<int[]> getSlotPositions() {
        block11: {
            int itemY;
            int itemX;
            int i;
            if (this.slotPositions != null) break block11;
            this.slotPositions = new ArrayList<int[]>();
            int x = inputSlotPos[0];
            int y = inputSlotPos[1];
            if ((this.input_items + this.input_fluids) % 2 == 0 && this.input_items + this.input_fluids != 2) {
                for (i = 0; i < this.input_fluids + this.input_items; ++i) {
                    itemX = x + i / 2 * margin;
                    itemY = y + i % 2 * margin;
                    this.slotPositions.add(new int[]{itemX, itemY});
                }
            } else {
                for (i = 0; i < this.input_fluids + this.input_items; ++i) {
                    if (this.input_fluids + this.input_items == 1 && this.output_items + this.output_fluids < 8) {
                        x += margin;
                    }
                    itemX = x + margin * i;
                    itemY = y + margin / 2;
                    this.slotPositions.add(new int[]{itemX, itemY});
                }
            }
            x = outputSlotPos[0];
            y = outputSlotPos[1];
            if (this.input_fluids + this.input_items > 5) {
                x += margin;
            }
            if (this.output_fluids + this.output_items > 6) {
                x -= margin;
            }
            if ((this.output_items + this.output_fluids) % 2 == 0 && this.isDoubleSlotHeight()) {
                for (i = 0; i < this.output_fluids + this.output_items; ++i) {
                    itemX = x + i / 2 * margin;
                    itemY = y + i % 2 * margin;
                    this.slotPositions.add(new int[]{itemX, itemY});
                }
            } else {
                for (i = 0; i < this.output_fluids + this.output_items; ++i) {
                    itemX = x + margin * i;
                    itemY = y + margin / 2;
                    this.slotPositions.add(new int[]{itemX, itemY});
                }
            }
        }
        return this.slotPositions;
    }

    public int slotsCount() {
        return this.input_items + this.input_fluids + this.output_items + this.output_fluids;
    }

    public ProcessorSlots setSlotPositions(List<int[]> slotPositions) {
        this.slotPositions = slotPositions;
        return this;
    }

    public String getSlotType(int id) {
        if (id < this.input_fluids) {
            return "fluid_in";
        }
        if (id < this.input_fluids + this.input_items) {
            return "item_in";
        }
        if (id < this.input_fluids + this.input_items + this.output_fluids) {
            return "fluid_out";
        }
        return "item_out";
    }

    public int[] getSlotPos(int id) {
        return this.getSlotPositions().get(id);
    }

    public boolean isDoubleSlotHeight() {
        return this.input_fluids > 3 || this.output_fluids > 3 || this.input_items > 3 || this.output_items == 2 || this.output_items > 3;
    }

    public boolean hasThreeRows() {
        return this.input_fluids == 3 || this.output_fluids == 3 || this.input_items == 3 || this.output_items == 3;
    }

    public int fluidSlotId(int i) {
        if (i < this.input_fluids) {
            return i;
        }
        return i - this.input_items;
    }

    public int outputSlotsCount() {
        return this.output_fluids + this.output_items;
    }
}

