/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.element.fluid;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import igentuman.nc.NuclearCraft;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.handler.event.client.InputEvents;
import igentuman.nc.network.toServer.PacketFlushSlotContent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

public class FluidTankRenderer
extends NCGuiElement {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected static final NumberFormat nf = NumberFormat.getIntegerInstance();
    protected static final int TEXTURE_SIZE = 16;
    protected static final int MIN_FLUID_HEIGHT = 1;
    protected final TooltipMode tooltipMode;
    protected boolean canVoid = false;
    protected final FluidTank tank;

    public static FluidTankRenderer tank(FluidTank fluidTank) {
        return new FluidTankRenderer(fluidTank, 16, 16, 0, 0);
    }

    public FluidTankRenderer pos(int[] slotPos) {
        this.x = slotPos[0];
        this.y = slotPos[1];
        return this;
    }

    public FluidTankRenderer canVoid() {
        this.canVoid = true;
        return this;
    }

    public FluidTankRenderer id(int i) {
        this.slotId = i;
        return this;
    }

    public FluidTankRenderer size(int i, int i1) {
        this.width = i;
        this.height = i1;
        return this;
    }

    public FluidTankRenderer pos(int i, int i1) {
        this.x = i;
        this.y = i1;
        return this;
    }

    public FluidTankRenderer(FluidTank tank, int width, int height, int[] pos) {
        this(tank, TooltipMode.SHOW_AMOUNT_AND_CAPACITY, width, height, pos[0], pos[1]);
    }

    @Override
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if ((double)this.X() <= pMouseX && pMouseX < (double)(this.X() + this.width) && (double)this.Y() <= pMouseY && pMouseY < (double)(this.Y() + this.height) && !this.tank.isEmpty() && InputEvents.SHIFT_PRESSED) {
            NuclearCraft.packetHandler().sendToServer(new PacketFlushSlotContent(this.getPosition(), this.slotId));
        }
        return false;
    }

    public FluidTankRenderer(FluidTank tank, int width, int height, int x, int y) {
        this(tank, TooltipMode.SHOW_AMOUNT_AND_CAPACITY, width, height, x, y);
    }

    public FluidTankRenderer(FluidTank tank, TooltipMode tooltipMode, int width, int height, int x, int y) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.tank = tank;
        this.tooltipMode = tooltipMode;
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY, float pTicks) {
        super.draw(graphics, mX, mY, pTicks);
        this.render(graphics, this.tank.getFluid());
    }

    public void render(GuiGraphics graphics, FluidStack fluidStack) {
        RenderSystem.enableBlend();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.X(), (float)this.Y(), 0.0f);
        this.drawFluid(graphics, this.width, this.height, fluidStack);
        graphics.m_280168_().m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void drawFluid(GuiGraphics graphics, int width, int height, FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid.m_6212_(Fluids.f_76191_)) {
            return;
        }
        TextureAtlasSprite fluidStillSprite = this.getStillFluidSprite(fluidStack);
        int fluidColor = this.getColorTint(fluidStack);
        long amount = fluidStack.getAmount();
        int capacity = Math.min(1, this.tank.getCapacity());
        long scaledAmount = amount * (long)height / (long)capacity;
        if (amount > 0L && scaledAmount < 1L) {
            scaledAmount = 1L;
        }
        if (scaledAmount > (long)height) {
            scaledAmount = height;
        }
        FluidTankRenderer.drawTiledSprite(graphics, width, height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture(fluidStack);
        Minecraft minecraft = Minecraft.m_91087_();
        return (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    private int getColorTint(FluidStack ingredient) {
        Fluid fluid = ingredient.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        return renderProperties.getTintColor(ingredient);
    }

    private static void drawTiledSprite(GuiGraphics graphics, int tiledWidth, int tiledHeight, int color, long scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        FluidTankRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        int yStart = tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    FluidTankRenderer.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + (float)maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    @Override
    public List<Component> getTooltips() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Fluid fluidType = this.tank.getFluid().getFluid();
        try {
            if (fluidType.m_6212_(Fluids.f_76191_)) {
                return tooltip;
            }
            MutableComponent displayName = MutableComponent.m_237204_((ComponentContents)this.tank.getFluid().getDisplayName().m_214077_());
            tooltip.add((Component)displayName.m_130940_(ChatFormatting.AQUA));
            long amount = this.tank.getFluid().getAmount();
            long milliBuckets = amount * 1000L / 1000L;
            if (this.tooltipMode == TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
                MutableComponent amountString = Component.m_237110_((String)"gui.nc.fluid_tank_renderer.amount_capacity", (Object[])new Object[]{nf.format(milliBuckets), nf.format(this.tank.getCapacity())});
                tooltip.add((Component)amountString.m_130940_(ChatFormatting.WHITE));
            } else if (this.tooltipMode == TooltipMode.SHOW_AMOUNT) {
                MutableComponent amountString = Component.m_237110_((String)"gui.nc.fluid_tank_renderer.amount", (Object[])new Object[]{nf.format(milliBuckets)});
                tooltip.add((Component)amountString.m_130940_(ChatFormatting.WHITE));
            }
            if (this.canVoid) {
                tooltip.add((Component)Component.m_237115_((String)"gui.nc.fluid_tank_renderer.can_void").m_130940_(ChatFormatting.GOLD));
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to get tooltip for fluid: " + e);
        }
        return tooltip;
    }

    @Override
    public int m_5711_() {
        return this.width;
    }

    public int m_93694_() {
        return this.height;
    }

    public static enum TooltipMode {
        SHOW_AMOUNT,
        SHOW_AMOUNT_AND_CAPACITY,
        ITEM_LIST;

    }
}

