/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.kugelblitz;

import dan200.computercraft.shared.Capabilities;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.kugelblitz.ChamberBE;
import igentuman.nc.block.entity.kugelblitz.ChamberTerminalBE;
import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ChamberPortBE
extends ChamberBE {
    public static String NAME = "chamber_port";
    @NBTField
    public byte analogSignal = 0;
    @NBTField
    public byte comparatorMode = (byte)2;
    @NBTField
    public BlockPos controllerPos;

    public ChamberPortBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, NAME);
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped) {
            return;
        }
        super.tickServer();
        if (this.multiblock() == null || this.controller() == null) {
            return;
        }
        byte wasSignal = this.analogSignal;
        boolean updated = this.sendOutPower();
        if (this.controllerPos == null) {
            this.controllerPos = this.controller().m_58899_();
            updated = true;
            this.m_6596_();
        }
        if (this.hasRedstoneSignal()) {
            this.controller().controllerEnabled = true;
        }
        this.updateAnalogSignal();
        updated = wasSignal != this.analogSignal || updated;
        Direction dir = this.getFacing();
        if (this.fluidHandler() != null) {
            updated = this.fluidHandler().pushFluids(dir, false, this.f_58858_) || updated;
            boolean bl = updated = this.fluidHandler().pullFluids(dir, false, this.f_58858_) || updated;
        }
        if (updated) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void updateAnalogSignal() {
        switch (this.comparatorMode) {
            case 1: {
                this.analogSignal = (byte)(this.controller().energyStorage.getEnergyStored() * 15 / this.controller().energyStorage.getMaxEnergyStored());
            }
        }
    }

    protected FluidCapabilityHandler fluidHandler() {
        return this.controller().contentHandler.fluidCapability;
    }

    protected <T> LazyOptional<T> fluidHandler(@Nullable Direction side) {
        return this.controller().contentHandler.getFluidCapability(side);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.controller() == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler(side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.controller().getEnergy().cast();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.controller().getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    protected boolean sendOutPower() {
        if (this.multiblock() == null) {
            return false;
        }
        AtomicInteger capacity = new AtomicInteger(this.controller().energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            for (Direction direction : Direction.values()) {
                boolean doContinue;
                BlockEntity be = this.m_58904_().m_7702_(this.f_58858_.m_121945_(direction));
                if (be == null || (doContinue = be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).map(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), this.controller().energyStorage.getMaxEnergyStored()), false);
                        capacity.addAndGet(-received);
                        this.controller().energyStorage.consumeEnergy(received);
                        this.m_6596_();
                        return capacity.get() > 0;
                    }
                    return true;
                }).orElse(true).booleanValue())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    @Override
    public ChamberTerminalBE<?> controller() {
        if (NuclearCraft.instance.isNcBeStopped || !this.m_58904_().m_5776_() && this.m_58904_().m_7654_() != null && !this.m_58904_().m_7654_().m_130010_()) {
            return null;
        }
        if (this.m_58904_().f_46443_ && this.controllerPos != null) {
            return (ChamberTerminalBE)this.m_58904_().m_7702_(this.controllerPos);
        }
        try {
            return (ChamberTerminalBE)this.multiblock().controller().controllerBE();
        }
        catch (NullPointerException e) {
            if (this.controllerPos != null) {
                return (ChamberTerminalBE)this.m_58904_().m_7702_(this.controllerPos);
            }
            return null;
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
        }
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        this.saveTagData(infoTag);
        tag.m_128365_("Info", (Tag)infoTag);
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Info", (Tag)infoTag);
        this.saveTagData(infoTag);
    }

    public int getEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage.getMaxEnergyStored();
    }

    public int energyPerTick() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyPerTick;
    }

    public void toggleComparatorMode() {
        this.comparatorMode = (byte)(this.comparatorMode + 1);
        if (this.comparatorMode > 2) {
            this.comparatorMode = 1;
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public FluidTank getFluidTank(int i) {
        if (this.controller() == null) {
            return null;
        }
        return this.controller().getFluidTank(i);
    }

    public static class SignalSource {
        public static final byte ENERGY = 1;
        public static final byte OVERFLOW = 2;
    }
}

