/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.hangglider.HangGlider;
import fuzs.hangglider.config.ClientConfig;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class GlidingCameraHandler {
    private static float gliderRotation;
    private static float gliderRotationOld;
    private static CameraType oldCameraType;

    public static void onEndClientTick(Minecraft minecraft) {
        if (minecraft.f_91074_ == null) {
            return;
        }
        if (((ClientConfig)HangGlider.CONFIG.get(ClientConfig.class)).autoThirdPersonGliding) {
            GlidingCameraHandler.setThirdPersonGliding((Player)minecraft.f_91074_, minecraft.f_91066_);
        }
        if (((ClientConfig)HangGlider.CONFIG.get(ClientConfig.class)).glidingCameraTilt) {
            GlidingCameraHandler.updateGlidingRotation((Player)minecraft.f_91074_);
        }
    }

    private static void setThirdPersonGliding(Player player, Options options) {
        if (PlayerGlidingHelper.isGliding(player)) {
            if (oldCameraType == null) {
                oldCameraType = options.m_92176_();
                if (options.m_92176_() == CameraType.FIRST_PERSON) {
                    options.m_92157_(CameraType.THIRD_PERSON_BACK);
                }
            }
        } else if (oldCameraType != null) {
            if (options.m_92176_() == CameraType.THIRD_PERSON_BACK) {
                options.m_92157_(oldCameraType);
            }
            oldCameraType = null;
        }
    }

    private static void updateGlidingRotation(Player player) {
        if (PlayerGlidingHelper.isGliding(player)) {
            Vec3 vector3d = player.m_20252_(1.0f);
            Vec3 vector3d1 = player.m_20184_();
            double d0 = vector3d1.m_165925_();
            double d1 = vector3d.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.f_82479_ * vector3d.f_82479_ + vector3d1.f_82481_ * vector3d.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.f_82479_ * vector3d.f_82481_ - vector3d1.f_82481_ * vector3d.f_82479_;
                float rotationDelta = (float)(Math.signum(d3) * Math.acos(Math.min(d2, 1.0)));
                rotationDelta = rotationDelta / (float)Math.PI * 180.0f * 0.4f * (float)((ClientConfig)HangGlider.CONFIG.get(ClientConfig.class)).glidingTiltAmount;
                gliderRotationOld = gliderRotation;
                gliderRotation += (rotationDelta - gliderRotation) * (float)((ClientConfig)HangGlider.CONFIG.get(ClientConfig.class)).glidingTiltSpeed;
            }
        } else {
            gliderRotation = 0.0f;
            gliderRotationOld = 0.0f;
        }
    }

    public static void onComputeCameraRoll(GameRenderer renderer, Camera camera, float tickDelta, MutableFloat pitch, MutableFloat yaw, MutableFloat roll) {
        if (((ClientConfig)HangGlider.CONFIG.get(ClientConfig.class)).glidingCameraTilt && (gliderRotation != 0.0f || gliderRotationOld != 0.0f)) {
            roll.accept(Mth.m_14179_((float)tickDelta, (float)gliderRotationOld, (float)gliderRotation));
        }
    }

    public static EventResult onRenderHand(Player player, InteractionHand hand, ItemStack stack, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, float partialTick, float interpolatedPitch, float swingProgress, float equipProgress) {
        return PlayerGlidingHelper.isGliding(player) ? EventResult.INTERRUPT : EventResult.PASS;
    }
}

