/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf.fluid;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import org.zeith.hammerlib.api.fluid.IExtendedFluidType;

public class FluidHelper {
    public static Optional<TooltipComponent> getFluidTooltipComponent(FluidStack fluid, boolean showCapacity, int capacity, boolean advancedItemTooltips) {
        return IExtendedFluidType.of(fluid).getTooltipImage(fluid, showCapacity, capacity, advancedItemTooltips);
    }

    public static List<Component> getFluidTooltip(FluidStack fluid, boolean showCapacity, int capacity, boolean advancedItemTooltips) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (!fluid.isEmpty()) {
            Component dn = fluid.getDisplayName();
            tooltip.add((Component)Component.m_237119_().m_7220_(dn).m_130938_(fluid.getFluid().getFluidType().getRarity(fluid).getStyleModifier()));
            NumberFormat nf = DecimalFormat.getIntegerInstance();
            tooltip.add((Component)(showCapacity ? Component.m_237110_((String)"info.hammerlib.fluid_capped", (Object[])new Object[]{nf.format(fluid.getAmount()), nf.format(capacity)}) : Component.m_237110_((String)"info.hammerlib.fluid_uncapped", (Object[])new Object[]{nf.format(fluid.getAmount())})).m_130940_(ChatFormatting.GRAY));
            if (advancedItemTooltips) {
                tooltip.add((Component)Component.m_237113_((String)BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"info.hammerlib.empty"));
        }
        return tooltip;
    }

    public static FluidStack limit(FluidStack fluid, int max) {
        if (fluid.isEmpty() || fluid.getAmount() <= max) {
            return fluid;
        }
        return FluidHelper.withAmount(fluid, max);
    }

    public static FluidStack withAmount(FluidStack fluid, int amount) {
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack fs = fluid.copy();
        fs.setAmount(amount);
        return fs;
    }

    public static boolean anyFluidMatches(ItemStack stack, Predicate<FluidStack> filter) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> {
            int slots = h.getTanks();
            for (int i = 0; i < slots; ++i) {
                if (!filter.test(h.getFluidInTank(i))) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public static boolean allFluidsMatch(ItemStack stack, Predicate<FluidStack> filter) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> {
            int slots = h.getTanks();
            for (int i = 0; i < slots; ++i) {
                if (filter.test(h.getFluidInTank(i))) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public static boolean noneFluidsMatch(ItemStack stack, Predicate<FluidStack> filter) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> {
            int slots = h.getTanks();
            for (int i = 0; i < slots; ++i) {
                if (!filter.test(h.getFluidInTank(i))) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public static boolean isFluidContainerEmpty(ItemStack stack) {
        return FluidHelper.allFluidsMatch(stack, FluidStack::isEmpty);
    }

    public static boolean isFluidContainerFull(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> {
            int slots = h.getTanks();
            for (int i = 0; i < slots; ++i) {
                FluidStack fs = h.getFluidInTank(i);
                if (!fs.isEmpty() && fs.getAmount() >= h.getTankCapacity(i)) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }
}

