/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.test.machine;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.zeith.api.wrench.IWrenchable;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.client.TileRenderer;
import org.zeith.hammerlib.api.crafting.ICraftingExecutor;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.api.recipes.IngredientWithCount;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.core.test.machine.BlockTestMachine;
import org.zeith.hammerlib.core.test.machine.ContainerTestMachine;
import org.zeith.hammerlib.core.test.machine.RecipeTestMachine;
import org.zeith.hammerlib.core.test.machine.TESRTestMachine;
import org.zeith.hammerlib.net.properties.PropertyInt;
import org.zeith.hammerlib.net.properties.PropertyResourceLocation;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.tiles.tooltip.EnumNumberFormat;
import org.zeith.hammerlib.tiles.tooltip.ProgressBar;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltip;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltipProvider;
import org.zeith.hammerlib.util.java.DirectStorage;

@SimplyRegister
public class TileTestMachine
extends TileSyncableTickable
implements IContainerTile,
ICraftingExecutor,
IWrenchable,
ITooltipProvider {
    @RegistryName(value="test_machine")
    @TileRenderer(value=TESRTestMachine.class)
    public static final BlockEntityType<TileTestMachine> TEST_MACHINE = BlockAPI.createBlockEntityType(TileTestMachine::new, new Block[]{BlockTestMachine.TEST_MACHINE});
    @NBTSerializable
    private int _progress;
    @NBTSerializable
    private int _maxProgress = 200;
    @NBTSerializable
    public final SimpleInventory inventory = new SimpleInventory(3);
    @NBTSerializable
    private ResourceLocation _activeRecipeId;
    public final PropertyInt progress = new PropertyInt(DirectStorage.create(i -> {
        this._progress = i;
    }, () -> this._progress));
    public final PropertyInt maxProgress = new PropertyInt(DirectStorage.create(i -> {
        this._maxProgress = i;
    }, () -> this._maxProgress));
    public final PropertyResourceLocation activeRecipeId = new PropertyResourceLocation(DirectStorage.create(r -> {
        this._activeRecipeId = r;
    }, () -> this._activeRecipeId));
    public final PropertyInt uiProgress = new PropertyInt();
    public boolean dirty;

    public TileTestMachine(BlockPos pos, BlockState state) {
        super(TEST_MACHINE, pos, state);
        this.inventory.isStackValid = (i, s) -> i != 2;
        this.dispatcher.registerProperty("progress", this.progress);
        this.dispatcher.registerProperty("max_progress", this.maxProgress);
        this.dispatcher.registerProperty("ar_id", this.activeRecipeId);
    }

    @Override
    public void serverTick() {
        RecipeTestMachine recipe;
        RecipeTestMachine r = this.getActiveRecipe();
        if (this.isValidRecipe(r)) {
            int p = this._progress + 1;
            if (p >= r.getTime()) {
                ItemStack result = r.getRecipeOutput(this);
                if (this.output(result)) {
                    this.inventory.m_8020_(0).m_41774_(r.inputA.count());
                    this.inventory.m_8020_(1).m_41774_(r.inputB.count());
                    if (!this.isValidRecipe(r)) {
                        this.activeRecipeId.set(null);
                        r = null;
                        this.setEnabledState(false);
                    }
                    this.progress.setInt(0);
                }
            } else {
                this.progress.setInt(p);
            }
        } else {
            if (this._progress > 0) {
                this.progress.setInt(this._progress - 1);
                if (this._progress <= 0) {
                    this.setEnabledState(false);
                }
            }
            this.activeRecipeId.set(null);
            r = null;
        }
        this.uiProgress.set(this._progress);
        if (r == null && this.atTickRate(10) && (recipe = (RecipeTestMachine)RecipeHelper.getRecipes(this.f_58857_, RecipeTestMachine.TYPE).filter(this::isValidRecipe).findFirst().orElse(null)) != null) {
            if (recipe.time != this._maxProgress) {
                this.progress.setInt(0);
            }
            this.maxProgress.setInt(recipe.time);
            this.activeRecipeId.set(recipe.m_6423_());
            this.setEnabledState(true);
        }
    }

    @Override
    public void clientTick() {
        this.setTooltipDirty(true);
    }

    public void setEnabledState(boolean enabled) {
        BlockState s = this.f_58857_.m_8055_(this.f_58858_);
        if (s.m_60734_() == BlockTestMachine.TEST_MACHINE) {
            s = (BlockState)s.m_61124_((Property)BlockStateProperties.f_61431_, (Comparable)Boolean.valueOf(enabled));
            this.f_58857_.m_46597_(this.f_58858_, s);
            this.m_155250_(s);
        }
    }

    public RecipeTestMachine getActiveRecipe() {
        return RecipeHelper.getRecipeMap(this.f_58857_, RecipeTestMachine.TYPE).get(this._activeRecipeId);
    }

    private boolean output(ItemStack stack) {
        if (this.canStore(stack)) {
            ItemStack s = this.inventory.m_8020_(2);
            if (s.m_41619_()) {
                this.inventory.m_6836_(2, stack);
            } else {
                this.inventory.m_8020_(2).m_41769_(stack.m_41613_());
            }
            return true;
        }
        return false;
    }

    private boolean isValidRecipe(RecipeTestMachine recipe) {
        return recipe != null && recipe.inputA.test(this.inventory.m_8020_(0)) && recipe.inputB.test(this.inventory.m_8020_(1)) && this.canStore(recipe.getRecipeOutput(this));
    }

    private boolean canStore(ItemStack result) {
        ItemStack stack = this.inventory.m_8020_(2);
        if (stack.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_150942_((ItemStack)result, (ItemStack)stack)) {
            return false;
        }
        return stack.m_41613_() + result.m_41613_() <= Math.min(this.inventory.m_6893_(), result.m_41741_());
    }

    @Override
    public AbstractContainerMenu openContainer(Player player, int windowId) {
        return new ContainerTestMachine(player, windowId, this);
    }

    @Override
    public boolean onWrenchUsed(UseOnContext context) {
        Direction facing;
        Direction origin;
        BlockState state;
        if (context.m_43725_().m_5776_()) {
            return true;
        }
        Direction d = context.m_43719_();
        if (context.m_43723_().m_6144_()) {
            d = d.m_122424_();
        }
        if ((state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() == BlockTestMachine.TEST_MACHINE && (origin = (facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))) != (facing = d == Direction.UP ? facing.m_122427_() : (d == Direction.DOWN ? facing.m_122428_() : d))) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing));
        }
        return true;
    }

    @Override
    public boolean isTooltipDirty() {
        return this.dirty;
    }

    @Override
    public void setTooltipDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void addInformation(ITooltip tip) {
        RecipeTestMachine recipe = this.getActiveRecipe();
        if (recipe != null) {
            IngredientWithCount ingA = recipe.inputA;
            IngredientWithCount ingB = recipe.inputB;
            ItemStack stored0 = this.inventory.m_8020_(0);
            ItemStack stored1 = this.inventory.m_8020_(1);
            ItemStack inA = ingA.test(stored0) ? stored0.m_41777_() : RecipeHelper.cycleIngredientStack(ingA.input(), 1000L);
            ItemStack inB = ingB.test(stored1) ? stored1.m_41777_() : RecipeHelper.cycleIngredientStack(ingB.input(), 1000L);
            if (!inA.m_41619_()) {
                inA.m_41764_(recipe.inputA.count());
            }
            if (!inB.m_41619_()) {
                inB.m_41764_(recipe.inputB.count());
            }
            tip.addStack(inA, 9.0f, 9.0f).addText((Component)Component.m_237113_((String)" + ")).addStack(inB, 9.0f, 9.0f).addText((Component)Component.m_237113_((String)" = ")).addStack(recipe.getRecipeOutput(this), 9.0f, 9.0f).newLine();
            tip.addSpacing(0.0f, 4.0f).newLine();
            ProgressBar bar = new ProgressBar(this._maxProgress).setProgress(this._progress).withStyle(ProgressBar.ProgressBarStyle.FORGE_ENERGY_STYLE).withNumberFormat(EnumNumberFormat.FULL);
            float hue = bar.getProgress() / 3.5f;
            bar.filledMainColor = 0xFF000000 | Mth.m_14169_((float)hue, (float)1.0f, (float)1.0f);
            bar.filledAlternateColor = 0xFF000000 | Mth.m_14169_((float)hue, (float)1.0f, (float)0.75f);
            tip.addText((Component)Component.m_237113_((String)"Progress: ")).addProgressBar(bar);
        }
    }
}

