/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.util.java.net.HttpRequest;
import org.zeith.hammerlib.util.mcf.ModHelper;

public class HttpTextureWithHeaders
extends HttpTexture {
    public static final Map<String, String> EXTRA_HEADERS = new HashMap<String, String>();

    public HttpTextureWithHeaders(@Nullable File cacheFile, String url, ResourceLocation texturePath, boolean convertMcSkin, @Nullable Runnable onDownloaded) {
        super(cacheFile, url, texturePath, convertMcSkin, onDownloaded);
    }

    public void m_117966_() {
        super.m_117966_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.f_118129_);
    }

    public void m_6704_(ResourceManager resources) throws IOException {
        if (this.f_117998_ == null) {
            NativeImage nativeimage;
            if (this.f_117994_ != null && this.f_117994_.isFile()) {
                f_117993_.debug("Loading http texture from local cache ({})", (Object)this.f_117994_);
                FileInputStream fileinputstream = new FileInputStream(this.f_117994_);
                nativeimage = this.m_118018_(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.m_118010_(nativeimage);
            } else {
                this.f_117998_ = CompletableFuture.runAsync(() -> {
                    f_117993_.debug("Downloading http texture from {} to {}", (Object)this.f_117995_, (Object)this.f_117994_);
                    try (HttpRequest req = HttpRequest.get(this.f_117995_).useProxy(Minecraft.m_91087_().m_91096_()).headers(EXTRA_HEADERS);){
                        if (req.code() / 100 == 2) {
                            InputStream inputstream;
                            if (this.f_117994_ != null) {
                                FileUtils.copyInputStreamToFile((InputStream)req.stream(), (File)this.f_117994_);
                                inputstream = new FileInputStream(this.f_117994_);
                            } else {
                                inputstream = req.stream();
                            }
                            NativeImage image = this.m_118018_(inputstream);
                            Minecraft.m_91087_().execute(() -> {
                                if (image != null) {
                                    this.m_118010_(image);
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        f_117993_.error("Couldn't download http texture", (Throwable)exception);
                    }
                }, Util.m_183991_());
            }
        }
    }

    private void m_118010_(NativeImage image) {
        if (this.f_117997_ != null) {
            this.f_117997_.run();
        }
        Minecraft.m_91087_().execute(() -> {
            this.f_117999_ = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.m_118020_(image));
            } else {
                this.m_118020_(image);
            }
        });
    }

    private void m_118020_(NativeImage image) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)image.m_84982_(), (int)image.m_85084_());
        image.m_85040_(0, 0, 0, true);
    }

    @javax.annotation.Nullable
    private NativeImage m_118018_(InputStream stream) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.m_85058_((InputStream)stream);
        }
        catch (Exception exception) {
            f_117993_.warn("Error while loading the URL texture", (Throwable)exception);
        }
        return nativeimage;
    }

    static {
        EXTRA_HEADERS.put("User-Agent", "HammerLib-based HTTP Texture Downloader (" + ModHelper.getModVersion("hammerlib") + ")");
    }
}

