/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.reader;

import net.minecraft.client.Minecraft;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.annotations.ide.AllowedValues;
import org.zeith.hammerlib.annotations.ide.Default;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.data.FlowQuery;
import org.zeith.hammerlib.client.flowgui.objects.GuiRootObject;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiRegistry;
import org.zeith.hammerlib.client.flowgui.reader.GuiReader;

final class RootReader
extends GuiReader<GuiRootObject> {
    static final RootReader INSTANCE = new RootReader();
    @AllowedValues(value={"^true|false$"})
    @Default(value="false")
    public static final String KEY_DEBUG = "debug";
    @AllowedValues(value={"^true|false$"})
    @Default(value="true")
    public static final String KEY_SMOOTH = "smooth";

    RootReader() {
    }

    @Override
    protected GuiRootObject readObject(KeyMap map, String name, IDataNode attributes) {
        GuiRootObject root = GuiRootObject.root();
        root.debugBoundaries = attributes.getBoolean(KEY_DEBUG);
        map.put(FlowguiRegistry.GUI_ROOT, root);
        FlowQuery query = map.get(FlowguiRegistry.QUERY);
        boolean smooth = attributes.getBooleanOrDefault(KEY_SMOOTH, true);
        root.onPreRender((partialTime, mouse) -> {
            if (smooth) {
                partialTime = Minecraft.m_91087_().getPartialTick();
            }
            query.partialTime = partialTime;
            query.time = ((double)query.ticks + query.partialTime) / 20.0;
        });
        root.onTick(() -> {
            query.partialTime = 0.0;
            ++query.ticks;
        });
        return root;
    }
}

