/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.proxy;

import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.zeith.hammerlib.util.java.Cast;

public interface IProxy {
    default public Player getClientPlayer() {
        return null;
    }

    default public Level getClientLevel() {
        return null;
    }

    public static <T> T create(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return switch (FMLEnvironment.dist) {
            case Dist.CLIENT -> Cast.cast(clientTarget.get().get());
            case Dist.DEDICATED_SERVER -> Cast.cast(serverTarget.get().get());
            default -> throw new IllegalArgumentException("UNSIDED?");
        };
    }

    public static <T> T createSided(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return switch (FMLEnvironment.dist) {
            case Dist.CLIENT -> Cast.cast(clientTarget.get().get());
            case Dist.DEDICATED_SERVER -> Cast.cast(serverTarget.get().get());
            default -> throw new IllegalArgumentException("UNSIDED?");
        };
    }

    public static void runSided(Supplier<Runnable> clientTarget, Supplier<Runnable> serverTarget) {
        switch (FMLEnvironment.dist) {
            case CLIENT: {
                clientTarget.get().run();
                break;
            }
            case DEDICATED_SERVER: {
                serverTarget.get().run();
                break;
            }
            default: {
                throw new IllegalArgumentException("UNSIDED?");
            }
        }
    }
}

