/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.EntityAwareEnergyStorage;
import xfacthd.framedblocks.common.util.ExternalItemHandler;

public class PoweredFramingSawBlockEntity
extends BlockEntity {
    public static final int ENERGY_CAPACITY = 5000;
    public static final int ENERGY_MAX_INSERT = 250;
    public static final int ENERGY_CONSUMPTION = 50;
    private static final boolean INSERT_ENERGY_DEBUG = false;
    private static final long ACTIVE_TIMEOUT = 40L;
    public static final int MAX_PROGRESS = 30;
    private final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            PoweredFramingSawBlockEntity.this.onContentsChanged(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return PoweredFramingSawBlockEntity.this.isValidItem(slot, stack);
        }
    };
    private final IItemHandler externalItemHandler = new ExternalItemHandler((IItemHandler)this.itemHandler){

        @Override
        protected boolean canExtract(int slot) {
            return slot == 4;
        }
    };
    private final RecipeWrapper container = new RecipeWrapper((IItemHandlerModifiable)this.itemHandler);
    private final EntityAwareEnergyStorage energyStorage = new EntityAwareEnergyStorage(5000, 250, 0, this);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private FramingSawRecipeCache cache = null;
    private ResourceLocation selectedRecipeId = null;
    private FramingSawRecipe selectedRecipe = null;
    private boolean active = false;
    private long lastActive = 0L;
    private boolean recipeSatisfied = false;
    private FramingSawRecipeMatchResult matchResult = null;
    private FramingSawRecipeCalculation calculation = null;
    private int outputCount = 0;
    private int progress = 0;
    private boolean needSaving = false;
    private boolean inhibitUpdate = false;
    private boolean internalAccess = false;

    public PoweredFramingSawBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(FBContent.BE_TYPE_POWERED_FRAMING_SAW.get(), pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PoweredFramingSawBlockEntity be) {
        if (!FMLEnvironment.production) {
            // empty if block
        }
        if ((be.active || level.m_46467_() - be.lastActive > 40L) && be.canRun()) {
            if (!be.active) {
                be.active = true;
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)PropertyHolder.ACTIVE, (Comparable)Boolean.valueOf(true)));
            }
            be.energyStorage.extractEnergyInternal(50);
            ++be.progress;
            if (be.progress >= 30) {
                be.progress = 0;
                ItemStack result = be.selectedRecipe.getResult().m_41777_();
                result.m_41764_(be.outputCount);
                be.internalAccess = true;
                be.inhibitUpdate = true;
                for (int i = 0; i < be.selectedRecipe.getAdditives().size(); ++i) {
                    int slot = i + 1;
                    be.itemHandler.extractItem(slot, be.calculation.getAdditiveCount(i), false);
                }
                be.inhibitUpdate = false;
                be.itemHandler.extractItem(0, be.calculation.getInputCount(), false);
                be.itemHandler.insertItem(4, result, false);
                be.internalAccess = false;
            }
        } else if (be.active) {
            be.active = false;
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)PropertyHolder.ACTIVE, (Comparable)Boolean.valueOf(false)));
            be.lastActive = level.m_46467_();
            if (!be.recipeSatisfied) {
                be.progress = 0;
            }
        }
        if (be.needSaving) {
            be.m_6596_();
            be.needSaving = false;
        }
    }

    private boolean canRun() {
        if (this.selectedRecipe == null || !this.recipeSatisfied) {
            return false;
        }
        if (this.energyStorage.getEnergyStored() < 50) {
            return false;
        }
        ItemStack output = this.itemHandler.getStackInSlot(4);
        if (!output.m_41619_() && output.m_41720_() != this.selectedRecipe.getResult().m_41720_()) {
            return false;
        }
        return output.m_41613_() + this.outputCount <= output.m_41741_();
    }

    private void checkRecipeSatisfied() {
        if (this.selectedRecipe != null) {
            this.matchResult = this.selectedRecipe.matchWithResult((Container)this.container, this.f_58857_);
            this.recipeSatisfied = this.matchResult.success();
        } else {
            this.matchResult = null;
            this.recipeSatisfied = false;
        }
        if (this.recipeSatisfied) {
            this.calculation = this.selectedRecipe.makeCraftingCalculation((Container)this.container, false);
            this.outputCount = this.calculation.getOutputCount();
        } else {
            this.calculation = null;
            this.outputCount = 0;
            this.progress = 0;
        }
    }

    private void onContentsChanged(int slot) {
        this.needSaving = true;
        if (slot != 4 && !this.inhibitUpdate) {
            this.checkRecipeSatisfied();
        }
    }

    private boolean isValidItem(int slot, ItemStack stack) {
        if (slot == 0) {
            return this.cache.getMaterialValue(stack.m_41720_()) > 0;
        }
        if (slot < 4) {
            if (this.selectedRecipe != null) {
                int idx = slot - 1;
                List<FramingSawRecipeAdditive> additives = this.selectedRecipe.getAdditives();
                if (!additives.isEmpty() && idx < additives.size()) {
                    return additives.get(idx).ingredient().test(stack);
                }
                return false;
            }
            return true;
        }
        if (slot == 4) {
            return this.internalAccess;
        }
        throw new IllegalArgumentException("Invalid slot: " + slot);
    }

    public void selectRecipe(FramingSawRecipe recipe) {
        ResourceLocation lastId = this.selectedRecipeId;
        this.selectedRecipe = recipe;
        this.selectedRecipeId = recipe == null ? null : recipe.m_6423_();
        this.checkRecipeSatisfied();
        if (!Objects.equals(lastId, this.selectedRecipeId)) {
            this.needSaving = true;
        }
    }

    public FramingSawRecipe getSelectedRecipe() {
        return this.selectedRecipe;
    }

    public FramingSawRecipeMatchResult getMatchResult() {
        return this.matchResult;
    }

    public int getProgress() {
        return this.progress;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public void dropContents(Consumer<ItemStack> dropper) {
        this.inhibitUpdate = true;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            dropper.accept(this.itemHandler.getStackInSlot(i));
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.inhibitUpdate = false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (side != Direction.UP) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return this.lazyItemHandler.cast();
            }
            if (cap == ForgeCapabilities.ENERGY) {
                return this.lazyEnergyStorage.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.externalItemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
        this.cache = FramingSawRecipeCache.get(this.f_58857_.m_5776_());
        if (this.selectedRecipeId != null && !this.f_58857_.m_5776_()) {
            FramingSawRecipe recipe = this.f_58857_.m_7465_().m_44043_(this.selectedRecipeId).filter(FramingSawRecipe.class::isInstance).map(FramingSawRecipe.class::cast).orElse(null);
            this.selectRecipe(recipe);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.selectedRecipe != null) {
            tag.m_128359_("recipe", this.selectedRecipe.m_6423_().toString());
        }
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("recipe")) {
            this.selectedRecipeId = new ResourceLocation(tag.m_128461_("recipe"));
        }
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
    }
}

