/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.storage.AEKeyFilter;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.parts.PartModel;
import appeng.util.ConfigInventory;
import com.glodblock.github.extendedae.common.parts.PartExInterface;
import com.glodblock.github.extendedae.config.EPPConfig;
import com.glodblock.github.extendedae.container.ContainerExInterface;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class PartOversizeInterface
extends PartExInterface {
    public static List<ResourceLocation> MODELS = Arrays.asList(new ResourceLocation("expatternprovider", "part/oversize_interface"), new ResourceLocation("ae2", "part/interface_on"), new ResourceLocation("ae2", "part/interface_off"), new ResourceLocation("ae2", "part/interface_has_channel"));
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(2)});
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(1)});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(3)});

    public PartOversizeInterface(IPartItem<?> partItem) {
        super(partItem);
        InterfaceLogic logic = this.getInterfaceLogic();
        Ae2Reflect.setInterfaceConfig(logic, new OversizeConfigInv(null, GenericStackInv.Mode.CONFIG_STACKS, 36, () -> Ae2Reflect.onInterfaceConfigChange(logic), false));
        Ae2Reflect.setInterfaceStorage(logic, new OversizeConfigInv(null, GenericStackInv.Mode.STORAGE, 36, () -> Ae2Reflect.onInterfaceStorageChange(logic), true));
        this.getConfig().useRegisteredCapacities();
        this.getStorage().useRegisteredCapacities();
    }

    @Override
    public void openMenu(Player player, MenuLocator locator) {
        MenuOpener.open(ContainerExInterface.TYPE_OVERSIZE, (Player)player, (MenuLocator)locator);
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(ContainerExInterface.TYPE_OVERSIZE, (Player)player, (MenuLocator)subMenu.getLocator());
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capabilityClass) {
        return this.getInterfaceLogic().getCapability(capabilityClass, this.getSide());
    }

    private static class OversizeConfigInv
    extends ConfigInventory {
        private OversizeConfigInv(@Nullable AEKeyFilter filter, GenericStackInv.Mode mode, int size, @Nullable Runnable listener, boolean allowOverstacking) {
            super(filter, mode, size, listener, allowOverstacking);
        }

        public long getMaxAmount(AEKey key) {
            try {
                return Math.multiplyExact(super.getMaxAmount(key), EPPConfig.oversizeMultiplier);
            }
            catch (Exception e) {
                return Long.MAX_VALUE;
            }
        }
    }
}

