/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.mixin;

import com.enderio.EnderIO;
import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.data.recipes.AlloyRecipeProvider;
import com.enderio.machines.mixin.AbstractCookingRecipeAccessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class}, priority=1098)
public class RecipeManagerMixin {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Final
    @Shadow
    private ICondition.IContext context;

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void onRecipeReload(Map<ResourceLocation, JsonElement> recipes, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        HashMap inheritedRecipes = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> e : recipes.entrySet()) {
            JsonElement jsonElement;
            ResourceLocation recipeId = e.getKey();
            if (recipeId.m_135815_().startsWith("_") || !(jsonElement = e.getValue()).isJsonObject()) continue;
            this.enderio$handleRecipe(recipeId, jsonElement.getAsJsonObject(), inheritedRecipes::put);
        }
        recipes.putAll(inheritedRecipes);
    }

    @Unique
    private void enderio$handleRecipe(ResourceLocation recipeId, JsonObject recipeJson, BiFunction<ResourceLocation, JsonElement, JsonElement> recipeCallback) {
        if (!recipeJson.has("type") || !recipeJson.get("type").getAsString().equals("minecraft:smelting")) {
            return;
        }
        try {
            Recipe recipe;
            if ((!recipeJson.isJsonObject() || CraftingHelper.processConditions((JsonObject)recipeJson.getAsJsonObject(), (String)"conditions", (ICondition.IContext)this.context)) && (recipe = RecipeManager.fromJson((ResourceLocation)recipeId, (JsonObject)GsonHelper.m_13918_((JsonElement)recipeJson, (String)"top element"), (ICondition.IContext)this.context)) != null && recipe instanceof SmeltingRecipe) {
                SmeltingRecipe smeltingRecipe = (SmeltingRecipe)recipe;
                Optional<AlloyRecipeProvider.FinishedAlloyingRecipe> convertedRecipe = RecipeManagerMixin.enderio$convert(recipeId, smeltingRecipe);
                if (convertedRecipe.isEmpty()) {
                    return;
                }
                JsonObject serialized = convertedRecipe.get().m_125966_();
                recipeCallback.apply(convertedRecipe.get().m_6445_(), (JsonElement)serialized);
            }
        }
        catch (Exception exception) {
            EnderIO.LOGGER.error("Skipping inheritance of smelting recipe {}: {}", (Object)recipeId, (Object)exception);
        }
    }

    @Unique
    private static Optional<AlloyRecipeProvider.FinishedAlloyingRecipe> enderio$convert(ResourceLocation originalId, SmeltingRecipe smeltingRecipe) {
        AbstractCookingRecipeAccessor accessor = (AbstractCookingRecipeAccessor)smeltingRecipe;
        if (accessor.getResult().m_41619_()) {
            EnderIO.LOGGER.warn("Unable to inherit the cooking recipe with ID: {}. Reason: The result item is empty.", (Object)originalId);
            return Optional.empty();
        }
        String path = "smelting/" + originalId.m_135827_() + "/" + originalId.m_135815_();
        ResourceLocation id = EnderIO.loc(path);
        CountedIngredient input = new CountedIngredient(accessor.getIngredient(), 1);
        int energy = (Integer)MachinesConfig.COMMON.ENERGY.ALLOY_SMELTER_VANILLA_ITEM_ENERGY.get();
        AlloyRecipeProvider.FinishedAlloyingRecipe recipe = new AlloyRecipeProvider.FinishedAlloyingRecipe(id, List.of(input), accessor.getResult(), energy, accessor.getExperience(), true);
        return Optional.of(recipe);
    }
}

