/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.defaultworldtype.mixin;

import de.melanx.defaultworldtype.ClientConfig;
import de.melanx.defaultworldtype.DefaultWorldType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PresetFlatWorldScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={CreateWorldScreen.class})
public abstract class CreateWorldScreenMixin {
    @Redirect(method={"openFresh"}, at=@At(value="NEW", target="(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/gui/screens/Screen;Lnet/minecraft/client/gui/screens/worldselection/WorldCreationContext;Ljava/util/Optional;Ljava/util/OptionalLong;)Lnet/minecraft/client/gui/screens/worldselection/CreateWorldScreen;"))
    private static CreateWorldScreen modifyWorldScreen(Minecraft minecraft, Screen lastScreen, WorldCreationContext settings, Optional<ResourceKey<WorldPreset>> oldPreset, OptionalLong seed) {
        List<ResourceLocation> presets = settings.m_246480_().m_175515_(Registries.f_256729_).m_6579_().stream().map(Map.Entry::getKey).map(ResourceKey::m_135782_).toList();
        String file = presets.size() + " possible world presets found:\n" + presets.stream().map(location -> "- \"" + location + "\"").collect(Collectors.joining("\n"));
        try {
            Files.writeString(ClientConfig.CONFIG_PATH.resolve("world-presets.txt"), (CharSequence)file, new OpenOption[0]);
        }
        catch (IOException e) {
            DefaultWorldType.LOGGER.error("Couldn't generate file with existing presets", (Throwable)e);
        }
        Optional holder = settings.m_246480_().m_175515_(Registries.f_256729_).m_203636_(ClientConfig.getKey());
        CreateWorldScreen createWorldScreen = new CreateWorldScreen(minecraft, lastScreen, settings, oldPreset, seed);
        if (holder.isPresent()) {
            Holder.Reference preset = (Holder.Reference)holder.get();
            DefaultWorldType.LOGGER.info("Set world type to " + ClientConfig.getKey().m_135782_());
            ArrayList presetList = new ArrayList(createWorldScreen.m_267748_().m_267815_());
            presetList.addAll(createWorldScreen.m_267748_().m_267674_());
            for (WorldCreationUiState.WorldTypeEntry worldTypeEntry : presetList) {
                if (worldTypeEntry.f_267398_() != preset) continue;
                createWorldScreen.m_267748_().m_267576_(worldTypeEntry);
                if (!preset.m_203565_(WorldPresets.f_226438_)) break;
                createWorldScreen.m_267748_().m_267717_((registry, worldDimensions) -> {
                    HolderLookup.RegistryLookup block = settings.m_246480_().m_255025_(Registries.f_256747_);
                    HolderLookup.RegistryLookup biome = settings.m_246480_().m_255025_(Registries.f_256952_);
                    HolderLookup.RegistryLookup structureSet = settings.m_246480_().m_255025_(Registries.f_256998_);
                    HolderLookup.RegistryLookup placedFeature = settings.m_246480_().m_255025_(Registries.f_256988_);
                    FlatLevelSource flatLevelSource = new FlatLevelSource(PresetFlatWorldScreen.m_257717_((HolderGetter)block, (HolderGetter)biome, (HolderGetter)structureSet, (HolderGetter)placedFeature, (String)((String)ClientConfig.flatMapSettings.get()), (FlatLevelGeneratorSettings)FlatLevelGeneratorSettings.m_254980_((HolderGetter)biome, (HolderGetter)structureSet, (HolderGetter)placedFeature)));
                    return worldDimensions.m_246747_((RegistryAccess)registry, (ChunkGenerator)flatLevelSource);
                });
                break;
            }
        }
        return createWorldScreen;
    }
}

