/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.MultipartBakedModel;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.hash.LambdaBasedHash;
import org.embeddedt.vintagefix.util.PredicateHelper;

public class Deduplicator {
    private static final Map<String, String> VARIANT_IDENTITIES = new ConcurrentHashMap<String, String>();
    private static final Map<Map<Predicate<IBlockState>, IBakedModel>, MultipartBakedModel> KNOWN_MULTIPART_MODELS = new ConcurrentHashMap<Map<Predicate<IBlockState>, IBakedModel>, MultipartBakedModel>();
    private static final Map<List<Predicate<IBlockState>>, Predicate<IBlockState>> OR_PREDICATE_CACHE = new ConcurrentHashMap<List<Predicate<IBlockState>>, Predicate<IBlockState>>();
    private static final Map<List<Predicate<IBlockState>>, Predicate<IBlockState>> AND_PREDICATE_CACHE = new ConcurrentHashMap<List<Predicate<IBlockState>>, Predicate<IBlockState>>();
    private static final ObjectOpenCustomHashSet<int[]> BAKED_QUAD_CACHE = new ObjectOpenCustomHashSet(new LambdaBasedHash<int[]>(Deduplicator::betterIntArrayHash, Arrays::equals));
    private static final MethodHandle BAKED_QUAD_VERTEX_FIELD;

    public static String deduplicateVariant(String variant) {
        return VARIANT_IDENTITIES.computeIfAbsent(variant, Function.identity());
    }

    private static int betterIntArrayHash(int[] in) {
        int result = 0;
        for (int i : in) {
            result = 31 * result + HashCommon.murmurHash3((int)i);
        }
        return result;
    }

    public static MultipartBakedModel makeMultipartModel(Map<Predicate<IBlockState>, IBakedModel> selectors) {
        return KNOWN_MULTIPART_MODELS.computeIfAbsent((Map<Predicate<IBlockState>, IBakedModel>)ImmutableMap.copyOf(selectors), MultipartBakedModel::new);
    }

    public static Predicate<IBlockState> or(List<Predicate<IBlockState>> list) {
        return OR_PREDICATE_CACHE.computeIfAbsent(list, PredicateHelper::or);
    }

    public static Predicate<IBlockState> and(List<Predicate<IBlockState>> list) {
        return AND_PREDICATE_CACHE.computeIfAbsent(list, PredicateHelper::and);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deduplicate(BakedQuad bq) {
        ObjectOpenCustomHashSet<int[]> objectOpenCustomHashSet = BAKED_QUAD_CACHE;
        synchronized (objectOpenCustomHashSet) {
            int[] deduped = (int[])BAKED_QUAD_CACHE.addOrGet((Object)bq.func_178209_a());
            try {
                BAKED_QUAD_VERTEX_FIELD.invokeExact(bq, deduped);
            }
            catch (Throwable e) {
                VintageFix.LOGGER.error("Cannot deduplicate BakedQuad", e);
            }
        }
    }

    public static void registerReloadListener() {
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void func_110549_a(IResourceManager resourceManager) {
                VARIANT_IDENTITIES.clear();
                KNOWN_MULTIPART_MODELS.clear();
                OR_PREDICATE_CACHE.clear();
                AND_PREDICATE_CACHE.clear();
                ObjectOpenCustomHashSet objectOpenCustomHashSet = BAKED_QUAD_CACHE;
                synchronized (objectOpenCustomHashSet) {
                    BAKED_QUAD_CACHE.clear();
                    BAKED_QUAD_CACHE.trim();
                }
            }
        });
    }

    static {
        try {
            Field field = ObfuscationReflectionHelper.findField(BakedQuad.class, (String)"field_178215_a");
            field.setAccessible(true);
            BAKED_QUAD_VERTEX_FIELD = MethodHandles.lookup().unreflectSetter(field);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

