/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.core.MixinConfigPlugin;
import org.embeddedt.vintagefix.dynamicresources.model.DynamicBakedModelProvider;
import org.embeddedt.vintagefix.dynamicresources.model.ModelLocationInformation;

public class DynamicModelProvider
implements IRegistry<ResourceLocation, IModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static DynamicModelProvider instance;
    private final Set<ICustomModelLoader> loaders;
    private final Map<ResourceLocation, IModel> permanentlyLoadedModels = new Object2ObjectOpenHashMap();
    private final Cache<ResourceLocation, Optional<IModel>> loadedModels = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build();
    public static Set<ResourceLocation> textureCapturer;
    private final Map<ResourceLocation, ResourceLocation> sideChannelAliases = new Object2ObjectOpenHashMap();
    public static final boolean HIDE_MODEL_ERRORS;
    private static final ICustomModelLoader VANILLA_LOADER;
    private static final ICustomModelLoader VARIANT_LOADER;
    private static final Map<ResourceLocation, IModel> MODEL_LOADER_REGISTRY_CACHE;
    private static final Class<?> VANILLA_MODEL_WRAPPER;

    public DynamicModelProvider(Set<ICustomModelLoader> loaders) {
        this.loaders = loaders;
        this.sideChannelAliases.put(new ResourceLocation("block/builtin/entity"), new ResourceLocation("builtin/entity"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IModel getObject(ResourceLocation location) {
        Optional<IModel> opt = (Optional<IModel>)this.loadedModels.getIfPresent((Object)location);
        if (opt == null) {
            DynamicModelProvider dynamicModelProvider = this;
            synchronized (dynamicModelProvider) {
                opt = (Optional)this.loadedModels.getIfPresent((Object)location);
                if (opt == null) {
                    try {
                        opt = Optional.ofNullable(this.loadModelFromBlockstateOrInventory(location));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (textureCapturer != null && opt.isPresent()) {
                        textureCapturer.addAll(opt.get().getTextures());
                    }
                    this.loadedModels.put((Object)location, opt);
                }
            }
        }
        return opt.orElse(null);
    }

    public void clearCache() {
        this.loadedModels.invalidateAll();
    }

    public IModel getModelOrMissing(ResourceLocation location) {
        try {
            return this.getObject(location);
        }
        catch (RuntimeException e) {
            return this.getObject((ResourceLocation)new ModelResourceLocation("builtin/missing", "missing"));
        }
    }

    private IModel loadModelFromBlockstateOrInventory(ResourceLocation location) throws ModelLoaderRegistry.LoaderException {
        IModel model;
        Throwable normalException;
        Throwable blockStateException;
        ResourceLocation inventoryVariantLocation;
        block13: {
            inventoryVariantLocation = null;
            blockStateException = null;
            normalException = null;
            model = null;
            try {
                model = this.loadModel(location, new LinkedHashSet<ResourceLocation>());
            }
            catch (Throwable e) {
                blockStateException = e;
                if (!(location instanceof ModelResourceLocation)) break block13;
                inventoryVariantLocation = ModelLocationInformation.getInventoryVariantLocation((ModelResourceLocation)location);
                if (inventoryVariantLocation == null) {
                    inventoryVariantLocation = new ResourceLocation(location.func_110624_b(), location.func_110623_a());
                }
                try {
                    model = this.loadModel(inventoryVariantLocation, new LinkedHashSet<ResourceLocation>());
                    if (VANILLA_MODEL_WRAPPER.isAssignableFrom(model.getClass())) {
                        for (ResourceLocation dep : ((ModelBlock)model.asVanillaModel().get()).func_187965_e()) {
                            if (location.equals((Object)dep)) continue;
                            ModelLocationInformation.addInventoryVariantLocation(ModelLocationInformation.getInventoryVariant(dep.toString()), dep);
                        }
                    }
                }
                catch (Throwable e2) {
                    normalException = e;
                }
            }
        }
        if (model == null) {
            ModelLoaderRegistry.LoaderException theException = new ModelLoaderRegistry.LoaderException("Model loading failure for " + location);
            if (blockStateException != null) {
                theException.addSuppressed(blockStateException);
            }
            if (normalException != null) {
                theException.addSuppressed(normalException);
            }
            if (HIDE_MODEL_ERRORS) {
                blockStateException = null;
                normalException = null;
            }
            if (ModelLocationInformation.canLogError(location.func_110624_b())) {
                LOGGER.error("Failed to load model {}", (Object)location, (Object)blockStateException);
                if (normalException != null) {
                    LOGGER.error("Failed to load model {} as item {}", (Object)location, (Object)inventoryVariantLocation, (Object)normalException);
                }
            }
            throw theException;
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IModel loadModel(ResourceLocation location, Set<ResourceLocation> loadStack) throws ModelLoaderRegistry.LoaderException {
        IModel model;
        if (loadStack.add(location)) {
            ResourceLocation alias;
            Map<ResourceLocation, ResourceLocation> map = this.sideChannelAliases;
            synchronized (map) {
                alias = this.sideChannelAliases.get(location);
            }
            if (alias != null) {
                return this.loadModel(alias, loadStack);
            }
        }
        if ((model = this.permanentlyLoadedModels.get(location)) != null) {
            return model;
        }
        model = MODEL_LOADER_REGISTRY_CACHE.get(location);
        if (model != null) {
            return model;
        }
        if (ModelLocationInformation.DEBUG_MODEL_LOAD) {
            VintageFix.LOGGER.info("Loading model {}", (Object)location);
        }
        ResourceLocation actualLocation = ModelLoaderRegistry.getActualLocation((ResourceLocation)location);
        ICustomModelLoader accepted = null;
        for (ICustomModelLoader loader : this.loaders) {
            try {
                if (!loader.accepts(actualLocation)) continue;
                if (accepted != null) {
                    throw new ModelLoaderRegistry.LoaderException("Loaders (" + accepted + " and " + loader + ") both accept model " + location);
                }
                accepted = loader;
            }
            catch (Exception e) {
                throw new ModelLoaderRegistry.LoaderException("Exception checking if model " + location + " can be loaded with loader " + loader, (Throwable)e);
            }
        }
        if (accepted == null) {
            boolean isBuiltin;
            boolean bl = isBuiltin = actualLocation.func_110623_a().startsWith("builtin/") || actualLocation.func_110623_a().startsWith("block/builtin/") || actualLocation.func_110623_a().startsWith("item/builtin/");
            if (!isBuiltin && VARIANT_LOADER.accepts(actualLocation)) {
                accepted = VARIANT_LOADER;
            } else if (VANILLA_LOADER.accepts(actualLocation)) {
                accepted = VANILLA_LOADER;
            }
        }
        if (accepted == null) {
            throw new ModelLoaderRegistry.LoaderException("No suitable loader found for the model " + location);
        }
        try {
            model = accepted.loadModel(actualLocation);
        }
        catch (Exception e) {
            throw new ModelLoaderRegistry.LoaderException("Exception loading model " + location + " with loader " + accepted, (Throwable)e);
        }
        if (model == null) {
            throw new ModelLoaderRegistry.LoaderException("Loader " + accepted + " provided null model for " + location);
        }
        if (model == ModelLoaderRegistry.getMissingModel() && !location.equals((Object)DynamicBakedModelProvider.MISSING_MODEL_LOCATION)) {
            throw new ModelLoaderRegistry.LoaderException("Loader " + accepted + " provided missing model for " + location);
        }
        try {
            model.getTextures();
        }
        catch (Exception e) {
            throw new ModelLoaderRegistry.LoaderException("Exception loading model " + location + " with loader " + accepted, (Throwable)e);
        }
        return model;
    }

    public void putObject(ResourceLocation key, IModel value) {
        this.permanentlyLoadedModels.put(key, value);
        this.loadedModels.invalidate((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAlias(ResourceLocation original, ResourceLocation to) {
        Map<ResourceLocation, ResourceLocation> map = this.sideChannelAliases;
        synchronized (map) {
            this.sideChannelAliases.put(original, to);
        }
    }

    public Set<ResourceLocation> func_148742_b() {
        return this.permanentlyLoadedModels.keySet();
    }

    public Iterator<IModel> iterator() {
        return this.permanentlyLoadedModels.values().iterator();
    }

    public void invalidate(ResourceLocation key) {
        this.loadedModels.invalidate((Object)key);
    }

    static {
        textureCapturer = null;
        HIDE_MODEL_ERRORS = MixinConfigPlugin.isMixinClassApplied("mixin.dynamic_resources.hide_model_exceptions.ModelErrorMixin");
        try {
            VANILLA_LOADER = (ICustomModelLoader)ObfuscationReflectionHelper.getPrivateValue(Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaLoader"), null, (String)"INSTANCE");
            VARIANT_LOADER = (ICustomModelLoader)ObfuscationReflectionHelper.getPrivateValue(Class.forName("net.minecraftforge.client.model.ModelLoader$VariantLoader"), null, (String)"INSTANCE");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        MODEL_LOADER_REGISTRY_CACHE = (Map)ObfuscationReflectionHelper.getPrivateValue(ModelLoaderRegistry.class, null, (String)"cache");
        try {
            VANILLA_MODEL_WRAPPER = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

