/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.dynamicresources.model.ModelLocationInformation;

public class WrappingModelRegistry
extends RegistrySimple<ModelResourceLocation, IBakedModel> {
    private final IRegistry<ModelResourceLocation, IBakedModel> delegate;
    private static final ImmutableSet<String> MODS_WITH_ITERATING_BAKE_EVENT = ImmutableSet.of((Object)"rebornmod", (Object)"secretroomsmod", (Object)"extratrees");

    public WrappingModelRegistry(IRegistry<ModelResourceLocation, IBakedModel> registry) {
        this.delegate = registry;
    }

    @Nullable
    public IBakedModel getObject(ModelResourceLocation name) {
        return (IBakedModel)this.delegate.func_82594_a((Object)name);
    }

    public void putObject(ModelResourceLocation key, IBakedModel value) {
        this.delegate.func_82595_a((Object)key, (Object)value);
    }

    public Set<ModelResourceLocation> func_148742_b() {
        ModContainer container = Loader.instance().activeModContainer();
        Set<ModelResourceLocation> extraSet = this.getExtraKeysForCaller(container);
        Set currentKeys = this.delegate.func_148742_b();
        if (extraSet == null) {
            return currentKeys;
        }
        return Sets.union(extraSet, (Set)currentKeys);
    }

    public boolean containsKey(ModelResourceLocation key) {
        return ModelLocationInformation.allKnownModelLocations.contains(key);
    }

    private Set<ModelResourceLocation> getExtraKeysForCaller(ModContainer container) {
        if (container == null) {
            return null;
        }
        if (!MODS_WITH_ITERATING_BAKE_EVENT.contains((Object)container.getModId())) {
            VintageFix.LOGGER.warn("Mod '{}' is attempting to iterate the model registry, but is not whitelisted in VintageFix. This may cause glitches if it wraps its own models.", (Object)container.getModId());
            return null;
        }
        return Sets.filter(ModelLocationInformation.allKnownModelLocations, loc -> container.getModId().equals(loc.func_110624_b()));
    }

    public Iterator<IBakedModel> iterator() {
        return this.delegate.iterator();
    }
}

