/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.unstabletools.crafting;

import com.google.gson.JsonObject;
import com.tfar.unstabletools.ObjectHolders;
import com.tfar.unstabletools.UnstableToolsConfig;
import com.tfar.unstabletools.crafting.IDivisionItem;
import javax.annotation.Nonnull;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeDivisionFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = recipe.getRecipeWidth();
        primer.height = recipe.getRecipeHeight();
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = recipe.func_192400_c();
        return new DivisionRecipe(new ResourceLocation("unstabletools", "division_crafting"), recipe.func_77571_b(), primer);
    }

    public static class DivisionRecipe
    extends ShapedOreRecipe {
        public DivisionRecipe(ResourceLocation group, ItemStack result, CraftingHelper.ShapedPrimer primer) {
            super(group, result, primer);
        }

        public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
            if (!super.func_77569_a(inv, world)) {
                return false;
            }
            ItemStack divisionSign = ItemStack.field_190927_a;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof IDivisionItem)) continue;
                divisionSign = stack;
            }
            NBTTagCompound nbt = divisionSign.func_77978_p();
            if (nbt == null) {
                return false;
            }
            boolean activated = nbt.func_74767_n("activated");
            Container c = (Container)ObfuscationReflectionHelper.getPrivateValue(InventoryCrafting.class, (Object)inv, (String)"field_70465_c");
            return UnstableToolsConfig.allowed_container_classes.contains(c.getClass()) && activated;
        }

        @Nonnull
        public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
            ItemStack newOutput = super.func_77572_b(inv);
            ItemStack divisionSign = ItemStack.field_190927_a;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof IDivisionItem)) continue;
                divisionSign = stack;
            }
            boolean stable = divisionSign.func_77978_p().func_74767_n("stable");
            if (stable) {
                return new ItemStack((Item)ObjectHolders.pseudo_unstable_ingot);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("timer", 200);
            newOutput.func_77982_d(nbt);
            return newOutput;
        }
    }
}

