/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.unstabletools;

import com.tfar.unstabletools.ObjectHolders;
import com.tfar.unstabletools.UnstableToolsConfig;
import com.tfar.unstabletools.armor.ItemUnstableArmor;
import com.tfar.unstabletools.block.BlockUnstableBlock;
import com.tfar.unstabletools.item.ItemDivisionSign;
import com.tfar.unstabletools.item.ItemUnstableIngot;
import com.tfar.unstabletools.tools.ItemUnstableAxe;
import com.tfar.unstabletools.tools.ItemUnstableHoe;
import com.tfar.unstabletools.tools.ItemUnstablePickaxe;
import com.tfar.unstabletools.tools.ItemUnstableShears;
import com.tfar.unstabletools.tools.ItemUnstableSpade;
import com.tfar.unstabletools.tools.ItemUnstableSword;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="unstabletools", name="Unstable Tools", version="@VERSION@", acceptedMinecraftVersions="[1.12.2]")
public class UnstableTools {
    public static final String MODID = "unstabletools";
    public static final String NAME = "Unstable Tools";
    public static final String VERSION = "@VERSION@";
    public static final Item.ToolMaterial UNSTABLE = EnumHelper.addToolMaterial((String)"UNSTABLE", (int)4, (int)Short.MAX_VALUE, (float)8.0f, (float)4.0f, (int)25);
    public static final ItemArmor.ArmorMaterial UNSTABLE_ARMOR = EnumHelper.addArmorMaterial((String)"unstabletools:unstable_armor", (String)"unstabletools:unstable", (int)Short.MAX_VALUE, (int[])new int[]{4, 7, 9, 4}, (int)25, (SoundEvent)SoundEvents.field_187719_p, (float)5.0f);
    public static final List<Item> MOD_ITEMS = new ArrayList<Item>();
    public static final List<Block> MOD_BLOCKS = new ArrayList<Block>();
    public static Logger logger;
    public static CreativeTabs creativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        UNSTABLE.setRepairItem(new ItemStack((Item)ObjectHolders.unstableIngot));
        OreDictionary.registerOre((String)"ingotUnstable", (Item)ObjectHolders.unstableIngot);
        OreDictionary.registerOre((String)"ingotUnstable", (Item)ObjectHolders.pseudo_unstable_ingot);
        OreDictionary.registerOre((String)"blockUnstable", (Block)ObjectHolders.unstableBlock);
        UnstableToolsConfig.sync();
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        UnstableTools.registerBlock(new BlockUnstableBlock(Material.field_151573_f), "unstable_block", (IForgeRegistry<Block>)registry, 3000.0f, 5.0f);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        UnstableTools.registerItem(new ItemUnstableIngot().func_77625_d(1), "unstable_ingot", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem(new ItemUnstableIngot(), "pseudo_unstable_ingot", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem((Item)new ItemUnstableShears(), "unstable_shears", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItemBlock(ObjectHolders.unstableBlock, (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem((Item)new ItemUnstableAxe(UNSTABLE), "unstable_axe", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem((Item)new ItemUnstableSpade(UNSTABLE), "unstable_spade", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem((Item)new ItemUnstablePickaxe(UNSTABLE), "unstable_pickaxe", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem((Item)new ItemUnstableSword(UNSTABLE), "unstable_sword", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem((Item)new ItemUnstableHoe(UNSTABLE), "unstable_hoe", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem((Item)new ItemUnstableArmor(UNSTABLE_ARMOR, EntityEquipmentSlot.HEAD), "unstable_helmet", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem((Item)new ItemUnstableArmor(UNSTABLE_ARMOR, EntityEquipmentSlot.CHEST), "unstable_chestplate", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem((Item)new ItemUnstableArmor(UNSTABLE_ARMOR, EntityEquipmentSlot.LEGS), "unstable_leggings", (IForgeRegistry<Item>)registry);
        UnstableTools.registerItem((Item)new ItemUnstableArmor(UNSTABLE_ARMOR, EntityEquipmentSlot.FEET), "unstable_boots", (IForgeRegistry<Item>)registry);
        ItemDivisionSign divisionSign = new ItemDivisionSign();
        divisionSign.func_77625_d(1);
        UnstableTools.registerItem(divisionSign, "division_sign", (IForgeRegistry<Item>)registry);
    }

    private static void registerBlock(Block block, String name, IForgeRegistry<Block> registry, float blastResistance, float hardness) {
        block.setRegistryName(name);
        block.func_149663_c(block.getRegistryName().toString());
        block.func_149647_a(creativeTab);
        block.func_149752_b(blastResistance);
        block.func_149711_c(hardness);
        MOD_BLOCKS.add(block);
        registry.register((IForgeRegistryEntry)block);
    }

    private static void registerItem(Item item, String name, IForgeRegistry<Item> registry) {
        item.setRegistryName(name);
        item.func_77655_b(item.getRegistryName().toString());
        item.func_77637_a(creativeTab);
        MOD_ITEMS.add(item);
        registry.register((IForgeRegistryEntry)item);
    }

    private static void registerItemBlock(Block block, IForgeRegistry<Item> registry) {
        ItemBlock itemBlock = new ItemBlock(block);
        itemBlock.setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)itemBlock);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Item item : MOD_ITEMS) {
            UnstableTools.registerModelLocation(item);
        }
        for (Block block : MOD_BLOCKS) {
            UnstableTools.registerModelLocation(Item.func_150898_a((Block)block));
        }
    }

    private static void registerModelLocation(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public static void onEvent(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityWither && event.getSource().func_76346_g() instanceof EntityPlayer && !(event.getSource().func_76346_g() instanceof FakePlayer)) {
            ItemStack itemStackToDrop = new ItemStack((Item)ObjectHolders.divisionSign);
            event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStackToDrop));
        }
    }

    static {
        creativeTab = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ObjectHolders.unstablePickaxe);
            }
        };
    }
}

