/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity;

import com.nekokittygames.thaumictinkerer.common.blocks.BlockRepairer;
import com.nekokittygames.thaumictinkerer.common.compat.TiConCompat;
import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityThaumicTinkerer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.client.fx.FXDispatcher;

public class TileEntityRepairer
extends TileEntityThaumicTinkerer
implements ITickable,
IAspectContainer,
IEssentiaTransport {
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityRepairer.this.sendUpdates();
        }

        public boolean isItemValidForSlot(int index, ItemStack stack) {
            return TileEntityRepairer.this.isItemValidForSlot(index, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private int ticksExisted;
    private int dmgLastTick = 0;
    private boolean tookLastTick = true;

    public int getTicksExisted() {
        return this.ticksExisted;
    }

    public void setTicksExisted(int ticksExisted) {
        this.ticksExisted = ticksExisted;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (Loader.isModLoaded((String)"tconstruct") && TTConfig.TiConCompatibility) {
            return TiConCompat.isRepairableTiCon(stack) || item.isRepairable();
        }
        return item.isRepairable();
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void writeExtraNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
    }

    @Override
    public void readExtraNBT(NBTTagCompound nbttagcompound) {
        this.inventory.deserializeNBT(nbttagcompound.func_74775_l("inventory"));
    }

    @Override
    public boolean respondsToPulses() {
        return false;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (++this.ticksExisted % 10 == 0) {
            int damage;
            ItemStack stack = this.inventory.getStackInSlot(0);
            if (Loader.isModLoaded((String)"tconstruct") && TTConfig.TiConCompatibility) {
                if (stack != ItemStack.field_190927_a) {
                    if (TiConCompat.isTiConTool(stack) && TTConfig.TiConCompatibility) {
                        int damage2 = TiConCompat.getDamage(stack);
                        if (damage2 > 0) {
                            int essentia = this.drawEssentia();
                            TiConCompat.fixDamage(stack, essentia);
                            this.sendUpdates();
                            if (this.dmgLastTick != 0 && this.dmgLastTick != damage2) {
                                FXDispatcher.INSTANCE.sparkle((float)((double)this.field_174879_c.func_177958_n() + 0.25 + Math.random() / 2.0), (float)((double)(this.field_174879_c.func_177956_o() + 1) + Math.random() / 2.0), (float)((double)this.field_174879_c.func_177952_p() + 0.25 + Math.random() / 2.0), 1.0f, 1.0f, 0.0f);
                                this.tookLastTick = true;
                            } else {
                                this.tookLastTick = false;
                            }
                        } else {
                            this.tookLastTick = false;
                        }
                        this.dmgLastTick = stack == ItemStack.field_190927_a ? 0 : TiConCompat.getDamage(stack);
                        return;
                    }
                    this.tookLastTick = false;
                } else {
                    this.tookLastTick = false;
                }
            }
            if ((damage = stack.func_77952_i()) > 0) {
                int essentia = this.drawEssentia();
                stack.func_77964_b(Math.max(0, stack.func_77952_i() - essentia));
                this.sendUpdates();
                if (this.dmgLastTick != 0 && this.dmgLastTick != damage) {
                    FXDispatcher.INSTANCE.sparkle((float)((double)this.field_174879_c.func_177958_n() + 0.25 + Math.random() / 2.0), (float)((double)(this.field_174879_c.func_177956_o() + 1) + Math.random() / 2.0), (float)((double)this.field_174879_c.func_177952_p() + 0.25 + Math.random() / 2.0), 1.0f, 1.0f, 0.0f);
                    this.tookLastTick = true;
                } else {
                    this.tookLastTick = false;
                }
            } else {
                this.tookLastTick = false;
            }
            this.dmgLastTick = stack == ItemStack.field_190927_a ? 0 : stack.func_77952_i();
        }
    }

    private int drawEssentia() {
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockRepairer.FACING);
        TileEntity te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)facing);
        if (te != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(facing.func_176734_d())) {
                return 0;
            }
            return ic.takeEssentia(Aspect.TOOL, 8, facing.func_176734_d());
        }
        return 0;
    }

    public AspectList getAspects() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack == ItemStack.field_190927_a) {
            return null;
        }
        int damage = stack.func_77952_i();
        if (Loader.isModLoaded((String)"tconstruct") && TTConfig.TiConCompatibility) {
            damage = TiConCompat.getDamage(stack);
        }
        return new AspectList().add(Aspect.TOOL, damage);
    }

    public void setAspects(AspectList aspectList) {
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return false;
    }

    public int addToContainer(Aspect aspect, int i) {
        return 0;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        return false;
    }

    public boolean takeFromContainer(AspectList aspectList) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        return false;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        return false;
    }

    public int containerContains(Aspect aspect) {
        return 0;
    }

    public boolean isConnectable(EnumFacing enumFacing) {
        return enumFacing == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockRepairer.FACING);
    }

    public boolean canInputFrom(EnumFacing enumFacing) {
        return false;
    }

    public boolean canOutputTo(EnumFacing enumFacing) {
        return this.isConnectable(enumFacing);
    }

    public void setSuction(Aspect aspect, int i) {
    }

    public Aspect getSuctionType(EnumFacing enumFacing) {
        return this.isConnectable(enumFacing) ? Aspect.TOOL : null;
    }

    public int getSuctionAmount(EnumFacing enumFacing) {
        return this.isConnectable(enumFacing) ? 128 : 0;
    }

    public int takeEssentia(Aspect aspect, int i, EnumFacing enumFacing) {
        return 0;
    }

    public int addEssentia(Aspect aspect, int i, EnumFacing enumFacing) {
        return 0;
    }

    public Aspect getEssentiaType(EnumFacing enumFacing) {
        return null;
    }

    public int getEssentiaAmount(EnumFacing enumFacing) {
        return 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean isTookLastTick() {
        return this.tookLastTick;
    }

    public void setTookLastTick(boolean tookLastTick) {
        this.tookLastTick = tookLastTick;
    }
}

