/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity;

import com.mojang.authlib.GameProfile;
import com.nekokittygames.thaumictinkerer.common.libs.LibMisc;
import com.nekokittygames.thaumictinkerer.common.misc.FakePlayerUtils;
import com.nekokittygames.thaumictinkerer.common.misc.ThaumicFakePlayer;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityThaumicTinkerer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityAnimationTablet
extends TileEntityThaumicTinkerer
implements ITickable,
Consumer<ItemStack> {
    private static final int SWING_SPEED = 3;
    private static final int MAX_DEGREE = 45;
    private boolean rightClick;
    private int progress;
    private int swingMod = 3;
    private EnumFacing facing;
    private boolean active;
    private int ticksExisted;
    private float curBlockDamageMP;
    private WeakReference<ThaumicFakePlayer> player;
    private boolean isRemoving;
    private ItemStack currentItemHittingBlock;
    private BlockPos currentBlock;
    List<Entity> detectedEntities = new ArrayList<Entity>();
    private ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityAnimationTablet.this.sendUpdates();
        }

        boolean isItemValidForSlot(int index, ItemStack stack) {
            return TileEntityAnimationTablet.this.isItemValidForSlot(index, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };

    public int getTicksExisted() {
        return this.ticksExisted;
    }

    public void setTicksExisted(int ticksExisted) {
        this.ticksExisted = ticksExisted;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public boolean isRightClick() {
        return this.rightClick;
    }

    public void setRightClick(boolean rightClick) {
        if (this.rightClick != rightClick) {
            this.resetAll();
        }
        this.rightClick = rightClick;
        this.sendUpdates();
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    private boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void writeExtraNBT(NBTTagCompound nbttagcompound) {
        super.writeExtraNBT(nbttagcompound);
        nbttagcompound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        nbttagcompound.func_74757_a("rightClick", this.rightClick);
        nbttagcompound.func_74768_a("progress", this.progress);
        nbttagcompound.func_74768_a("swingMod", this.swingMod);
        nbttagcompound.func_74768_a("facing", this.facing.func_176745_a());
        nbttagcompound.func_74757_a("active", this.active);
        if (this.currentItemHittingBlock != null) {
            nbttagcompound.func_74782_a("currentItemHittingBlock", (NBTBase)this.currentItemHittingBlock.serializeNBT());
            nbttagcompound.func_74782_a("currentBlock", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.currentBlock));
        }
        nbttagcompound.func_74757_a("isRemoving", this.isRemoving);
    }

    @Override
    public void readExtraNBT(NBTTagCompound nbttagcompound) {
        super.readExtraNBT(nbttagcompound);
        this.inventory.deserializeNBT(nbttagcompound.func_74775_l("inventory"));
        this.rightClick = nbttagcompound.func_74767_n("rightClick");
        this.progress = nbttagcompound.func_74762_e("progress");
        this.swingMod = nbttagcompound.func_74762_e("swingMod");
        this.facing = EnumFacing.values()[nbttagcompound.func_74762_e("facing")];
        this.active = nbttagcompound.func_74767_n("active");
        if (nbttagcompound.func_74764_b("currentItemHittingBlock")) {
            this.currentItemHittingBlock = new ItemStack(nbttagcompound.func_74775_l("currentItemHittingBlock"));
            this.currentBlock = NBTUtil.func_186861_c((NBTTagCompound)nbttagcompound.func_74775_l("currentBlock"));
        }
        this.isRemoving = nbttagcompound.func_74767_n("isRemoving");
    }

    @Override
    public boolean respondsToPulses() {
        return false;
    }

    @Override
    public boolean canRedstoneConnect() {
        return true;
    }

    @Override
    public void activateOnPulse() {
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != EnumFacing.DOWN) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != EnumFacing.DOWN && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    private boolean isHittingPosition(BlockPos pos, ThaumicFakePlayer player) {
        boolean flag;
        ItemStack itemstack = player.func_184614_ca();
        boolean bl = flag = this.currentItemHittingBlock.func_190926_b() && itemstack.func_190926_b();
        if (!this.currentItemHittingBlock.func_190926_b() && !itemstack.func_190926_b()) {
            flag = !this.currentItemHittingBlock.func_77973_b().shouldCauseBlockBreakReset(this.currentItemHittingBlock, itemstack);
        }
        return pos.equals((Object)this.currentBlock) && flag;
    }

    private void resetAll() {
        this.progress = 0;
        this.isRemoving = false;
        this.swingMod = 3;
        this.curBlockDamageMP = 0.0f;
    }

    private void initiateSwing() {
        this.swingMod = 3;
        this.progress = 1;
    }

    private boolean detect() {
        return !this.field_145850_b.func_175623_d(this.getBlockTarget()) || this.detectEntity().size() > 0;
    }

    private AxisAlignedBB getBlockBounding() {
        BlockPos newPos = this.func_174877_v().func_177972_a(this.facing);
        return new AxisAlignedBB(newPos);
    }

    private List<Entity> detectEntity() {
        AxisAlignedBB bounding = this.getBlockBounding();
        this.detectedEntities = this.field_145850_b.func_72872_a(Entity.class, bounding);
        return this.detectedEntities;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.player == null) {
            MinecraftServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            this.player = new WeakReference<ThaumicFakePlayer>(FakePlayerUtils.get(worldServer.func_71218_a(this.field_145850_b.field_73011_w.getDimension()), new GameProfile(LibMisc.MOD_UUID, "[ThaumicTinkerer]")));
        }
        ++this.ticksExisted;
        ItemStack stack = this.inventory.getStackInSlot(0);
        this.tick(stack);
        this.active = this.getRedstonePowered();
        boolean detect = this.detect();
        if (!detect && this.isRemoving) {
            this.stopBreaking();
        }
        if (detect && this.isRemoving && !this.field_145850_b.field_72995_K) {
            ((ThaumicFakePlayer)((Object)Objects.requireNonNull(this.player.get()))).field_71134_c.func_73075_a();
            this.continueBreaking();
        }
        if ((this.active || this.isRemoving) && detect && this.progress == 0) {
            this.initiateSwing();
        }
    }

    private void tick(ItemStack stack) {
        if (stack != ItemStack.field_190927_a) {
            if (!this.field_145850_b.field_72995_K && this.progress >= 45) {
                this.swingHit();
            }
            this.swingMod = this.progress <= 0 ? 0 : (this.progress >= 45 ? -3 : this.swingMod);
            this.progress += this.swingMod;
            if (this.progress < 0) {
                this.progress = 0;
            }
            this.sendUpdates();
        } else {
            this.resetAll();
        }
    }

    private BlockPos getTargetBlock() {
        Vec3d base = new Vec3d(((ThaumicFakePlayer)((Object)Objects.requireNonNull(this.player.get()))).field_70165_t, ((ThaumicFakePlayer)((Object)Objects.requireNonNull(this.player.get()))).field_70163_u, ((ThaumicFakePlayer)((Object)Objects.requireNonNull(this.player.get()))).field_70161_v);
        Vec3d look = ((ThaumicFakePlayer)((Object)Objects.requireNonNull(this.player.get()))).func_70040_Z();
        Vec3d target = base.func_178787_e(new Vec3d(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0));
        RayTraceResult trace = this.field_145850_b.func_147447_a(base, target, false, false, true);
        RayTraceResult traceEntity = FakePlayerUtils.traceEntities((ThaumicFakePlayer)((Object)this.player.get()), base, target, this.field_145850_b);
        RayTraceResult toUse = trace == null ? traceEntity : trace;
        return toUse.func_178782_a();
    }

    private void continueBreaking() {
        BlockPos targetPos = this.getTargetBlock();
        if (!this.rightClick) {
            this.curBlockDamageMP = !this.field_145850_b.func_180495_p(targetPos).func_177230_c().isAir(this.field_145850_b.func_180495_p(targetPos), (IBlockAccess)this.field_145850_b, this.field_174879_c) ? (this.curBlockDamageMP += this.field_145850_b.func_180495_p(targetPos).func_185903_a((EntityPlayer)Objects.requireNonNull(this.player.get()), ((ThaumicFakePlayer)((Object)this.player.get())).field_70170_p, targetPos)) : 0.0f;
            if (this.isRemoving && this.isHittingPosition(targetPos, (ThaumicFakePlayer)((Object)Objects.requireNonNull(this.player.get())))) {
                IBlockState iblockstate = this.field_145850_b.func_180495_p(targetPos);
                if (iblockstate.func_185904_a() == Material.field_151579_a) {
                    this.isRemoving = false;
                }
                this.curBlockDamageMP += iblockstate.func_185903_a((EntityPlayer)this.player.get(), this.field_145850_b, targetPos);
                if (this.curBlockDamageMP >= 1.0f) {
                    this.isRemoving = false;
                    ((ThaumicFakePlayer)((Object)this.player.get())).field_71134_c.func_180785_a(this.currentBlock);
                    this.onPlayerDestroyBlock(this.currentBlock, (ThaumicFakePlayer)((Object)this.player.get()));
                    this.curBlockDamageMP = 0.0f;
                }
                this.field_145850_b.func_175715_c(((ThaumicFakePlayer)((Object)this.player.get())).func_145782_y(), this.currentBlock, (int)(this.curBlockDamageMP * 10.0f) - 1);
            }
        }
    }

    public static void LookAt(double px, double py, double pz, Entity entity) {
        double dirx = (double)entity.func_180425_c().func_177958_n() - px;
        double diry = (double)entity.func_180425_c().func_177956_o() - py;
        double dirz = (double)entity.func_180425_c().func_177952_p() - pz;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        double pitch = Math.asin(diry /= len);
        double yaw = Math.atan2(dirz /= len, dirx /= len);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        entity.field_70125_A = (float)pitch;
        entity.field_70177_z = (float)(yaw += 90.0);
    }

    private void swingHit() {
        RayTraceResult toUse = null;
        FakePlayerUtils.setupFakePlayerForUse(this.getPlayer(), this.field_174879_c, this.facing, this.inventory.getStackInSlot(0).func_77946_l(), false);
        Vec3d base = new Vec3d(((ThaumicFakePlayer)((Object)Objects.requireNonNull(this.player.get()))).field_70165_t, ((ThaumicFakePlayer)((Object)this.player.get())).field_70163_u, ((ThaumicFakePlayer)((Object)this.player.get())).field_70161_v);
        Vec3d look = ((ThaumicFakePlayer)((Object)this.player.get())).func_70040_Z();
        Vec3d target = base.func_178787_e(new Vec3d(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0));
        RayTraceResult trace = this.field_145850_b.func_147447_a(base, target, false, false, true);
        RayTraceResult traceEntity = FakePlayerUtils.traceEntities((ThaumicFakePlayer)((Object)this.player.get()), base, target, this.field_145850_b);
        if (traceEntity == null && trace == null) {
            return;
        }
        toUse = traceEntity == null ? trace : traceEntity;
        BlockPos targetPos = toUse.func_178782_a();
        if (trace != null && traceEntity != null) {
            double d1 = trace.field_72307_f.func_72438_d(base);
            double d2 = traceEntity.field_72307_f.func_72438_d(base);
            RayTraceResult rayTraceResult = toUse = traceEntity.field_72313_a == RayTraceResult.Type.ENTITY && d1 > d2 ? traceEntity : trace;
        }
        if (toUse.field_72313_a == RayTraceResult.Type.BLOCK && this.field_145850_b.func_180495_p(targetPos) == this.field_145850_b.func_180495_p(this.field_174879_c)) {
            return;
        }
        if (!this.rightClick) {
            if (this.detectEntity().size() > 0) {
                Random rand = new Random();
                ((ThaumicFakePlayer)((Object)Objects.requireNonNull(this.player.get()))).func_71059_n(this.detectedEntities.get(rand.nextInt(this.detectedEntities.size())));
                FakePlayerUtils.cleanupFakePlayerFromUse(this.getPlayer(), ((ThaumicFakePlayer)((Object)this.player.get())).func_184614_ca(), this.inventory.getStackInSlot(0), this);
                return;
            }
            this.leftClick(toUse, this.getTargetBlock());
        } else {
            if (this.detectEntity().size() > 0) {
                Random rand = new Random();
                Entity entity = this.detectedEntities.get(rand.nextInt(this.detectedEntities.size()));
                if (FakePlayerUtils.processUseEntity((ThaumicFakePlayer)((Object)this.player.get()), entity, toUse, CPacketUseEntity.Action.INTERACT_AT)) {
                    FakePlayerUtils.cleanupFakePlayerFromUse(this.getPlayer(), ((ThaumicFakePlayer)((Object)this.player.get())).func_184614_ca(), this.inventory.getStackInSlot(0), this);
                    return;
                }
                if (FakePlayerUtils.processUseEntity((ThaumicFakePlayer)((Object)this.player.get()), entity, null, CPacketUseEntity.Action.INTERACT)) {
                    FakePlayerUtils.cleanupFakePlayerFromUse(this.getPlayer(), ((ThaumicFakePlayer)((Object)this.player.get())).func_184614_ca().func_77946_l(), this.inventory.getStackInSlot(0), this);
                    return;
                }
                return;
            }
            this.rightClick(toUse);
        }
    }

    private void rightClick(RayTraceResult toUse) {
        FakePlayerUtils.setupFakePlayerForUse(this.getPlayer(), this.field_174879_c, this.facing, this.inventory.getStackInSlot(0).func_77946_l(), false);
        ItemStack result = this.inventory.getStackInSlot(0);
        result = FakePlayerUtils.rightClickInDirection(this.getPlayer(), this.field_145850_b, this.field_174879_c, this.facing, this.field_145850_b.func_180495_p(this.field_174879_c), toUse);
        FakePlayerUtils.cleanupFakePlayerFromUse(this.getPlayer(), result, this.inventory.getStackInSlot(0), this);
    }

    private void leftClick(RayTraceResult toUse, BlockPos targetPos) {
        if (!this.isRemoving || !this.isHittingPosition(targetPos, (ThaumicFakePlayer)((Object)this.player.get()))) {
            ItemStack itm = FakePlayerUtils.leftClickInDirection(this.getPlayer(), this.field_145850_b, this.field_174879_c, this.facing, this.field_145850_b.func_180495_p(this.field_174879_c), toUse);
            if (toUse.field_72313_a == RayTraceResult.Type.BLOCK) {
                boolean flag;
                IBlockState iblockstate = this.field_145850_b.func_180495_p(targetPos);
                this.inventory.setStackInSlot(0, itm.func_77946_l());
                boolean bl = flag = iblockstate.func_185904_a() != Material.field_151579_a;
                if (flag && iblockstate.func_185903_a((EntityPlayer)this.player.get(), this.field_145850_b, targetPos) >= 1.0f) {
                    this.onPlayerDestroyBlock(targetPos, (ThaumicFakePlayer)((Object)this.player.get()));
                } else {
                    this.isRemoving = true;
                    this.currentBlock = targetPos;
                    this.currentItemHittingBlock = ((ThaumicFakePlayer)((Object)this.player.get())).func_184614_ca();
                    this.curBlockDamageMP = 0.0f;
                    this.field_145850_b.func_175715_c(((ThaumicFakePlayer)((Object)this.player.get())).func_145782_y(), this.currentBlock, (int)(this.curBlockDamageMP * 10.0f) - 1);
                }
            }
        }
    }

    private void stopBreaking() {
        this.isRemoving = false;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175715_c(((ThaumicFakePlayer)((Object)Objects.requireNonNull(this.player.get()))).func_145782_y(), this.currentBlock, -1);
        }
    }

    private void onPlayerDestroyBlock(BlockPos targetPos, ThaumicFakePlayer player) {
        boolean flag;
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b().onBlockStartBreak(stack, targetPos, (EntityPlayer)player)) {
            return;
        }
        IBlockState iblockstate = this.field_145850_b.func_180495_p(targetPos);
        Block block = iblockstate.func_177230_c();
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !player.func_189808_dh()) {
            return;
        }
        if (iblockstate.func_185904_a() == Material.field_151579_a) {
            return;
        }
        this.field_145850_b.func_175718_b(2001, targetPos, Block.func_176210_f((IBlockState)iblockstate));
        this.currentBlock = new BlockPos(this.currentBlock.func_177958_n(), -1, this.currentBlock.func_177952_p());
        ItemStack itemstack1 = player.func_184614_ca();
        ItemStack copyBeforeUse = itemstack1.func_77946_l();
        if (!itemstack1.func_190926_b()) {
            itemstack1.func_179548_a(this.field_145850_b, iblockstate, targetPos, (EntityPlayer)player);
            if (itemstack1.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)EnumHand.MAIN_HAND);
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
        }
        if (flag = block.removedByPlayer(iblockstate, this.field_145850_b, targetPos, (EntityPlayer)player, false)) {
            block.func_176206_d(this.field_145850_b, targetPos, iblockstate);
        }
    }

    private ThaumicFakePlayer getPlayer() {
        return (ThaumicFakePlayer)((Object)this.player.get());
    }

    private BlockPos getBlockTarget() {
        BlockPos newPos = this.func_174877_v().func_177972_a(this.facing);
        if (this.isRightClick() && this.field_145850_b.func_175623_d(newPos)) {
            newPos = newPos.func_177972_a(EnumFacing.DOWN);
        }
        return newPos;
    }

    @Override
    public void accept(ItemStack itemStack) {
        this.inventory.setStackInSlot(0, itemStack);
    }
}

