/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items;

import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.common.items.TTItem;
import com.nekokittygames.thaumictinkerer.common.utils.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemSoulMould
extends TTItem {
    public static final String TAG_ENTITYNAME = "entity_name";

    public ItemSoulMould() {
        super("soul_mould");
        this.func_185043_a(new ResourceLocation("thaumictinkerer", "full"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack itemStack, @Nullable World world, @Nullable EntityLivingBase entityLivingBase) {
                return ItemSoulMould.getEntityName(itemStack) != null ? 1.0f : 0.0f;
            }
        });
    }

    public static void setEntityName(ItemStack stack, EntityLivingBase entity) {
        ItemNBTHelper.setString(stack, TAG_ENTITYNAME, EntityList.func_75621_b((Entity)entity));
    }

    public static String getEntityName(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getItemTag(stack);
        if (cmp.func_74764_b(TAG_ENTITYNAME)) {
            return cmp.func_74779_i(TAG_ENTITYNAME);
        }
        return null;
    }

    public static void clearEntityName(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getItemTag(stack);
        cmp.func_82580_o(TAG_ENTITYNAME);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        RayTraceResult result = this.func_77621_a(worldIn, playerIn, false);
        if (result == null || result != null && result.field_72313_a == RayTraceResult.Type.MISS && playerIn.func_70093_af()) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            ItemSoulMould.clearEntityName(stack);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        ItemStack actualStack = playerIn.func_184586_b(hand);
        if (target != null && !(target instanceof EntityPlayer)) {
            ItemSoulMould.setEntityName(actualStack, target);
            return true;
        }
        return false;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String entityName = ItemSoulMould.getEntityName(stack);
        if (entityName == null) {
            tooltip.add(ThaumicTinkerer.proxy.localize("ttmisc.soulMould.nonAssigned", new Object[0]));
        } else {
            tooltip.add(ThaumicTinkerer.proxy.localize("ttmisc.soulMould.pattern", ThaumicTinkerer.proxy.localize("entity." + entityName + ".name", new Object[0])));
        }
    }
}

