/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.blocks;

import com.nekokittygames.thaumictinkerer.common.blocks.TTBlock;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityThaumicTinkerer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TTTileEntity<T extends TileEntity>
extends TTBlock {
    private final boolean preserveTileEntity;

    public TTTileEntity(String name, Material blockMaterialIn, MapColor blockMapColorIn, boolean preserveTileEntity) {
        super(name, blockMaterialIn, blockMapColorIn);
        this.func_149675_a(false);
        this.preserveTileEntity = preserveTileEntity;
    }

    public TTTileEntity(String name, Material materialIn, boolean preserveTileEntity) {
        super(name, materialIn);
        this.preserveTileEntity = preserveTileEntity;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    @Nullable
    protected T getTileEntity(IBlockAccess world, BlockPos pos) {
        return (T)world.func_175625_s(pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (this.preserveTileEntity && willHarvest && !player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        if (this.preserveTileEntity) {
            this.func_176208_a(world, pos, state, player);
            world.func_175698_g(pos);
            world.func_175713_t(pos);
        }
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        TileEntityThaumicTinkerer base;
        TileEntity tile;
        super.func_180650_b(world, pos, state, random);
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityThaumicTinkerer && (base = (TileEntityThaumicTinkerer)tile).respondsToPulses()) {
            base.activateOnPulse();
        }
    }

    public void customNeighborsChanged(World world, BlockPos pos) {
        this.updateRedstone(world, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.customNeighborsChanged(worldIn, pos);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        if (world instanceof World) {
            this.customNeighborsChanged((World)world, pos);
        }
    }

    public void updateRedstone(World world, BlockPos pos) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityThaumicTinkerer) {
            TileEntityThaumicTinkerer base = (TileEntityThaumicTinkerer)tile;
            boolean powered = world.func_175687_A(pos) > 0;
            boolean wasPowered = base.getRedstonePowered();
            if (powered && !wasPowered) {
                if (base.respondsToPulses()) {
                    world.func_175684_a(pos, (Block)this, 4);
                }
                base.setRedstonePowered(true);
            } else if (!powered && wasPowered) {
                base.setRedstonePowered(false);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.updateRedstone(worldIn, pos);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityThaumicTinkerer) {
            TileEntityThaumicTinkerer base = (TileEntityThaumicTinkerer)tile;
            return base.canRedstoneConnect();
        }
        return false;
    }
}

