/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.client.misc;

import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.shader.Shader;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;

public class Shaders {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    private static boolean canShader = true;
    private static boolean checkedShader = false;
    private static boolean lighting = false;
    private static int change_alpha = 0;

    public static int getChangeAlphaShader() {
        return change_alpha;
    }

    public static void initShaders() {
        if (Minecraft.func_71410_x().func_110442_L() instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(iResourceManager -> {
                Shaders.deleteProgram(change_alpha);
                change_alpha = 0;
                Shaders.loadShaders();
            });
        }
    }

    private static void loadShaders() {
        if (Shaders.areShadersDisabled()) {
            return;
        }
        change_alpha = Shaders.createProgram("/assets/thaumictinkerer/shaders/change_alpha.vert", "/assets/thaumictinkerer/shaders/change_alpha.frag");
        ThaumicTinkerer.logger.info("Looks like we can shade with the best of them!");
    }

    private static void deleteProgram(int program) {
        if (program != 0) {
            ARBShaderObjects.glDeleteObjectARB((int)program);
        }
    }

    public static void releaseShader() {
        if (lighting) {
            GlStateManager.func_179145_e();
        }
        Shaders.useShader(0);
    }

    private static void useShader(int shaderId) {
        Shaders.useShader(shaderId, null);
    }

    public static void useShader(int shaderId, Consumer<Integer> callback) {
        if (Shaders.areShadersDisabled()) {
            return;
        }
        lighting = GL11.glGetBoolean((int)2896);
        GlStateManager.func_179140_f();
        ARBShaderObjects.glUseProgramObjectARB((int)shaderId);
        if (shaderId != 0 && callback != null) {
            callback.accept(shaderId);
        }
    }

    private static int createProgram(String vertexFilename, String fragmentFilename) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vertexFilename != null) {
            vertId = Shaders.createShader(vertexFilename, 35633);
        }
        if (fragmentFilename != null) {
            fragId = Shaders.createShader(fragmentFilename, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vertexFilename != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (fragmentFilename != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            ThaumicTinkerer.logger.error(ARBShaderObjects.glGetInfoLogARB((int)program, (int)ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35716)));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            ThaumicTinkerer.logger.error(ARBShaderObjects.glGetInfoLogARB((int)program, (int)ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35716)));
            return 0;
        }
        ARBShaderObjects.glDeleteObjectARB((int)fragId);
        ARBShaderObjects.glDeleteObjectARB((int)vertId);
        return program;
    }

    private static int createShader(String fileName, int type) {
        int shaderId = 0;
        try {
            shaderId = ARBShaderObjects.glCreateShaderObjectARB((int)type);
            if (shaderId == 0) {
                return 0;
            }
            String shaderSource = Shaders.readFileAsString(fileName);
            ARBShaderObjects.glShaderSourceARB((int)shaderId, (CharSequence)shaderSource);
            ARBShaderObjects.glCompileShaderARB((int)shaderId);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shaderId, (int)35713) == 0) {
                ThaumicTinkerer.logger.error(ARBShaderObjects.glGetInfoLogARB((int)shaderId, (int)ARBShaderObjects.glGetObjectParameteriARB((int)shaderId, (int)35716)));
                return 0;
            }
            return shaderId;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shaderId);
            ThaumicTinkerer.logger.error("Error registering shader ", (Throwable)e);
            return 0;
        }
    }

    private static String readFileAsString(String filename) throws Exception {
        InputStream in = Shader.class.getResourceAsStream(filename);
        if (in == null) {
            return "";
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static boolean areShadersDisabled() {
        if (checkedShader) {
            return !canShader;
        }
        checkedShader = true;
        canShader = OpenGlHelper.func_153193_b() && TTConfig.ShadersEnabled && !Shaders.hasConflictingMods();
        return !canShader;
    }

    private static boolean hasConflictingMods() {
        return Loader.isModLoaded((String)"optifine");
    }
}

