/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.part;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.item.ItemPartBase;
import thaumicenergistics.part.PartBase;
import thaumicenergistics.util.EssentiaFilter;
import thaumicenergistics.util.inventory.ThEUpgradeInventory;

public abstract class PartSharedEssentiaBus
extends PartBase
implements IGridTickable,
IUpgradeableHost {
    public EssentiaFilter config;
    public ThEUpgradeInventory upgrades;
    protected boolean lastRedstone = true;
    public List<Runnable> upgradeChangeListeners = new ArrayList<Runnable>();

    public PartSharedEssentiaBus(ItemPartBase item) {
        this(item, 9, 4);
    }

    public PartSharedEssentiaBus(ItemPartBase item, int configSlots, int upgradeSlots) {
        super(item);
        this.config = new EssentiaFilter(configSlots){

            @Override
            protected void onContentsChanged() {
                super.onContentsChanged();
                PartSharedEssentiaBus.this.host.markForSave();
            }
        };
        this.upgrades = new ThEUpgradeInventory("upgrades", upgradeSlots, 1, this.getItemStack(PartItemStack.NETWORK)){

            @Override
            public void func_70296_d() {
                super.func_70296_d();
                PartSharedEssentiaBus.this.host.markForSave();
                PartSharedEssentiaBus.this.upgradeChangeListeners.forEach(Runnable::run);
            }
        };
    }

    protected int calculateAmountToSend() {
        switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
            case 4: {
                return 128;
            }
            case 3: {
                return 64;
            }
            case 2: {
                return 16;
            }
            case 1: {
                return 4;
            }
        }
        return 1;
    }

    public boolean hasInverterCard() {
        return this.getInstalledUpgrades(Upgrades.INVERTER) > 0;
    }

    public boolean hasRedstoneCard() {
        return this.getInstalledUpgrades(Upgrades.REDSTONE) > 0;
    }

    @Override
    public boolean canConnectRedstone() {
        return this.hasRedstoneCard();
    }

    @Override
    public double getIdlePowerUsage() {
        return 1.0;
    }

    @Nullable
    public TileEntity getConnectedTE() {
        TileEntity self = this.host.getTile();
        World w = self.func_145831_w();
        BlockPos pos = self.func_174877_v().func_177972_a(this.side.getFacing());
        if (w.func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) != null) {
            return w.func_175625_s(pos);
        }
        return null;
    }

    protected IEssentiaStorageChannel getChannel() {
        return (IEssentiaStorageChannel)AEApi.instance().storage().getStorageChannel(IEssentiaStorageChannel.class);
    }

    public EssentiaFilter getConfig() {
        return this.config;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.func_74764_b("config")) {
            this.config.deserializeNBT(tag.func_74775_l("config"));
        }
        if (tag.func_74764_b("upgrades")) {
            this.upgrades.deserializeNBT(tag.func_150295_c("upgrades", 10));
        }
        this.getConfigManager().readFromNBT(tag);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("config", (NBTBase)this.config.serializeNBT());
        tag.func_74782_a("upgrades", (NBTBase)this.upgrades.serializeNBT());
        this.getConfigManager().writeToNBT(tag);
    }

    @Override
    public int getInstalledUpgrades(Upgrades upgrade) {
        return this.upgrades.getUpgrades(upgrade);
    }

    @Override
    public TileEntity getTile() {
        return this.hostTile;
    }

    @Override
    public IItemHandler getInventoryByName(String s) {
        if (s.equalsIgnoreCase("upgrades")) {
            return new InvWrapper((IInventory)this.upgrades);
        }
        return null;
    }

    @Override
    public float getCableConnectionLength(AECableType aeCableType) {
        return 5.0f;
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        return this.canWork() && this.workAllowedByRedstone() ? this.doWork() : TickRateModulation.IDLE;
    }

    protected abstract TickRateModulation doWork();

    protected RedstoneMode getRSMode() {
        if (!this.hasRedstoneCard()) {
            return RedstoneMode.IGNORE;
        }
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    protected boolean hasRedstone() {
        return this.host.hasRedstone(this.side);
    }

    protected boolean workAllowedByRedstone() {
        boolean hasRedstone = this.hasRedstone();
        RedstoneMode mode = this.getRSMode();
        return !this.hasRedstoneCard() || mode == RedstoneMode.IGNORE || mode == RedstoneMode.HIGH_SIGNAL && hasRedstone || mode == RedstoneMode.LOW_SIGNAL && !hasRedstone;
    }

    @Override
    public void onNeighborChanged(IBlockAccess iBlockAccess, BlockPos blockPos, BlockPos blockPos1) {
        super.onNeighborChanged(iBlockAccess, blockPos, blockPos1);
        if (this.lastRedstone != this.hasRedstone()) {
            boolean bl = this.lastRedstone = !this.lastRedstone;
            if (this.lastRedstone && this.canWork() && this.getRSMode() == RedstoneMode.SIGNAL_PULSE) {
                this.doWork();
            }
        }
    }
}

