/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packets;

import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEStack;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.container.ActionType;
import thaumicenergistics.container.ContainerBase;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ThELog;

public class PacketUIAction
implements IMessage {
    public ActionType action;
    public IAEStack requestedStack;
    public int index = -1;
    private static final List<IStorageChannel<? extends IAEStack<? extends IAEStack<?>>>> validChannels = Lists.newArrayList((Object[])new IStorageChannel[]{AEUtil.getStorageChannel(IItemStorageChannel.class), AEUtil.getStorageChannel(IEssentiaStorageChannel.class)});

    public PacketUIAction() {
    }

    public PacketUIAction(ActionType action) {
        this.action = action;
    }

    public PacketUIAction(ActionType action, IAEStack stack) {
        this(action);
        this.requestedStack = stack;
    }

    public PacketUIAction(ActionType action, IAEStack stack, int index) {
        this(action);
        this.requestedStack = stack;
        this.index = index;
    }

    public PacketUIAction(ActionType action, int index) {
        this(action);
        this.index = index;
    }

    public void fromBytes(ByteBuf in) {
        NBTTagCompound nbt;
        PacketBuffer packetBuffer = new PacketBuffer(in);
        try {
            nbt = packetBuffer.func_150793_b();
        }
        catch (IOException e) {
            ThELog.error("Failed to read from packet, {}", e);
            return;
        }
        this.action = ActionType.values()[nbt.func_74762_e("action")];
        if (nbt.func_74764_b("index")) {
            this.index = nbt.func_74762_e("index");
        }
        if (nbt.func_74764_b("Cnt") || nbt.func_74764_b("Count")) {
            validChannels.forEach(channel -> {
                if (this.requestedStack == null) {
                    try {
                        this.requestedStack = channel.createFromNBT(nbt);
                    }
                    catch (Throwable ignored) {
                        ThELog.error("Failed to read stack from packet, {}", channel.getClass().getSimpleName());
                    }
                }
            });
        }
    }

    public void toBytes(ByteBuf outline) {
        PacketBuffer packetBuffer = new PacketBuffer(outline);
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.requestedStack != null) {
            this.requestedStack.writeToNBT(nbt);
        }
        if (this.index > -1) {
            nbt.func_74768_a("index", this.index);
        }
        nbt.func_74768_a("action", this.action.ordinal());
        packetBuffer.func_150786_a(nbt);
    }

    public static class Handler
    implements IMessageHandler<PacketUIAction, IMessage> {
        public IMessage onMessage(PacketUIAction message, MessageContext ctx) {
            NetHandlerPlayServer handler = ctx.getServerHandler();
            EntityPlayerMP player = handler.field_147369_b;
            IThreadListener thread = (IThreadListener)player.field_70170_p;
            thread.func_152344_a(() -> {
                if (player.field_71070_bA instanceof ContainerBase) {
                    ((ContainerBase)player.field_71070_bA).onAction(player, message);
                }
            });
            return null;
        }
    }
}

