/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.init;

import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumicenergistics.api.IThESounds;

@Mod.EventBusSubscriber
public class ThESounds
implements IThESounds {
    private static final HashMap<String, ResourceLocation> SOUNDS = new HashMap();
    private final ResourceLocation soundKnowledgeCoreWrite = ThESounds.addSound("knowledge_core_write");
    private final ResourceLocation soundKnowledgeCorePowerUp = ThESounds.addSound("knowledge_core_power_up");
    private final ResourceLocation soundKnowledgeCorePowerDown = ThESounds.addSound("knowledge_core_power_down");

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        SOUNDS.forEach((name, loc) -> {
            SoundEvent soundEvent = new SoundEvent(loc);
            soundEvent.setRegistryName(name);
            registry.register((IForgeRegistryEntry)soundEvent);
        });
    }

    private static ResourceLocation addSound(String sound) {
        ResourceLocation resourceLocation = new ResourceLocation("thaumicenergistics", sound);
        SoundEvent soundEvent = new SoundEvent(resourceLocation);
        soundEvent.setRegistryName(sound);
        SOUNDS.put(sound, resourceLocation);
        return resourceLocation;
    }

    @Override
    public ResourceLocation knowledgeCoreWrite() {
        return this.soundKnowledgeCoreWrite;
    }

    @Override
    public ResourceLocation knowledgeCorePowerUp() {
        return this.soundKnowledgeCorePowerUp;
    }

    @Override
    public ResourceLocation knowledgeCorePowerDown() {
        return this.soundKnowledgeCorePowerDown;
    }
}

