/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.init;

import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.ITileDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumicenergistics.ThaumicEnergistics;
import thaumicenergistics.api.IThEBlocks;
import thaumicenergistics.block.BlockArcaneAssembler;
import thaumicenergistics.block.BlockBase;
import thaumicenergistics.block.BlockInfusionProvider;
import thaumicenergistics.client.render.IThEModel;
import thaumicenergistics.definitions.ThEBlockDefinition;
import thaumicenergistics.definitions.ThETileDefinition;
import thaumicenergistics.tile.TileArcaneAssembler;
import thaumicenergistics.tile.TileInfusionProvider;

@Mod.EventBusSubscriber
public class ThEBlocks
implements IThEBlocks {
    public static List<BlockBase> BLOCKS = new ArrayList<BlockBase>();
    private final ITileDefinition infusionProvider = ThEBlocks.createTile(new BlockInfusionProvider("infusion_provider"), TileInfusionProvider.class);
    private final ITileDefinition arcaneAssembler = ThEBlocks.createTile(new BlockArcaneAssembler("arcane_assembler"), TileArcaneAssembler.class);

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ThaumicEnergistics.LOGGER.info("Registering Blocks");
        event.getRegistry().registerAll((IForgeRegistryEntry[])BLOCKS.toArray(new BlockBase[0]));
        BLOCKS.forEach(BlockBase::registerTileEntity);
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        ThaumicEnergistics.LOGGER.info("Registering ItemBlocks");
        BLOCKS.forEach(block -> event.getRegistry().register(new ItemBlock((Block)block).setRegistryName(Objects.requireNonNull(block.getRegistryName()))));
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        BLOCKS.forEach(block -> {
            if (block instanceof IThEModel) {
                ((IThEModel)((Object)block)).initModel();
            }
        });
    }

    private static IBlockDefinition createBlock(BlockBase block) {
        BLOCKS.add(block);
        return new ThEBlockDefinition(block, (Item)new ItemBlock((Block)block));
    }

    private static ITileDefinition createTile(BlockBase block, Class<? extends TileEntity> tile) {
        BLOCKS.add(block);
        return new ThETileDefinition(tile, block, (Item)new ItemBlock((Block)block));
    }

    @Override
    public ITileDefinition infusionProvider() {
        return this.infusionProvider;
    }

    @Override
    public ITileDefinition arcaneAssembler() {
        return this.arcaneAssembler;
    }
}

