/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.helpers;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.util.Platform;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import thaumcraft.api.aspects.AspectList;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.config.PrefixSetting;
import thaumicenergistics.client.gui.helpers.GuiScrollBar;
import thaumicenergistics.client.gui.helpers.ThEItemSorters;
import thaumicenergistics.integration.jei.ThEJEI;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.TCUtil;

public class MERepo<T extends IAEStack<T>> {
    private final IItemList<T> list;
    private ArrayList<T> view = new ArrayList();
    private String searchString = "";
    private String innerSearch = "";
    private ViewItems viewMode;
    private SortDir sortDir;
    private SortOrder sortOrder;
    private SearchBoxMode searchBoxMode;
    private GuiScrollBar scrollBar;
    private int rowSize = 9;
    private ViewItems lastView;
    private SearchBoxMode lastSearchMode;
    private SortOrder lastSortBy;
    private SortDir lastSortDir;
    private String lastSearch = "";
    private boolean resort = true;
    private boolean changed = false;

    public MERepo(Class<? extends IStorageChannel<T>> clazz) {
        this.list = AEUtil.getList(clazz);
        this.viewMode = ViewItems.ALL;
        this.sortDir = SortDir.ASCENDING;
        this.sortOrder = SortOrder.NAME;
        this.searchBoxMode = ThEApi.instance().config().searchBoxMode();
    }

    public void updateView() {
        Pattern pattern;
        if (this.lastView != this.viewMode) {
            this.resort = true;
            this.lastView = this.viewMode;
        }
        if (this.lastSearchMode != this.searchBoxMode) {
            this.resort = true;
            this.lastSearchMode = this.searchBoxMode;
        }
        if (!this.lastSearch.equals(this.searchString)) {
            this.resort = true;
            this.lastSearch = this.searchString;
        }
        if (this.lastSortBy != this.sortOrder) {
            this.resort = true;
            this.lastSortBy = this.sortOrder;
        }
        if (this.lastSortDir != this.sortDir) {
            this.resort = true;
            this.lastSortDir = this.sortDir;
        }
        if (!this.changed && !this.resort) {
            return;
        }
        this.changed = false;
        this.resort = false;
        this.view = new ArrayList();
        this.innerSearch = this.searchString.toLowerCase();
        boolean searchMod = false;
        boolean searchAspect = false;
        boolean searchSpecific = false;
        PrefixSetting modSearchSetting = ThEApi.instance().config().modSearchSetting();
        PrefixSetting aspectSearchSetting = ThEApi.instance().config().aspectSearchSetting();
        if (Stream.of(SearchBoxMode.JEI_AUTOSEARCH, SearchBoxMode.JEI_MANUAL_SEARCH, SearchBoxMode.JEI_AUTOSEARCH_KEEP, SearchBoxMode.JEI_MANUAL_SEARCH_KEEP).anyMatch(m -> m == this.searchBoxMode)) {
            ThEJEI.setSearchText(this.searchString);
        }
        switch (modSearchSetting) {
            case ENABLED: {
                searchMod = true;
            }
            case REQUIRE_PREFIX: {
                String modSearchPrefix = ThEApi.instance().config().modSearchPrefix();
                if (!this.innerSearch.startsWith(modSearchPrefix)) break;
                this.innerSearch = this.innerSearch.substring(modSearchPrefix.length());
                searchSpecific = true;
                searchMod = true;
            }
        }
        if (!searchSpecific) {
            switch (aspectSearchSetting) {
                case ENABLED: {
                    searchAspect = true;
                }
                case REQUIRE_PREFIX: {
                    String aspectSearchPrefix = ThEApi.instance().config().aspectSearchPrefix();
                    if (!this.innerSearch.startsWith(aspectSearchPrefix)) break;
                    this.innerSearch = this.innerSearch.substring(aspectSearchPrefix.length());
                    searchSpecific = true;
                    searchAspect = true;
                    searchMod = false;
                }
            }
        }
        try {
            pattern = Pattern.compile(this.innerSearch, 66);
        }
        catch (Throwable ignored) {
            try {
                pattern = Pattern.compile(Pattern.quote(this.innerSearch), 66);
            }
            catch (Throwable ignored2) {
                return;
            }
        }
        Pattern p = pattern;
        boolean finalSearchSpecific = searchSpecific;
        boolean searchByMod = searchMod;
        boolean searchByAspect = searchAspect;
        Lists.newArrayList(this.list).stream().filter(t -> this.getViewMode() != ViewItems.CRAFTABLE || t.isCraftable() || this.getViewMode() != ViewItems.STORED || t.getStackSize() != 0L).filter(t -> this.searchByQuery(finalSearchSpecific, searchByAspect, searchByMod, t, p)).forEach(t -> {
            IAEStack stack = t.copy();
            if (this.getViewMode().equals((Object)ViewItems.CRAFTABLE)) {
                if (!stack.isCraftable()) {
                    return;
                }
                stack.setStackSize(0L);
            } else if (this.getViewMode().equals((Object)ViewItems.STORED) && stack.getStackSize() < 1L) {
                return;
            }
            this.view.add(stack);
        });
        ThEItemSorters.setDirection(this.sortDir);
        ThEItemSorters.init();
        this.view.sort(MERepo.getComparator(this.sortOrder));
    }

    private static Comparator<IAEStack<?>> getComparator(SortOrder sortBy) {
        Comparator<IAEStack<?>> c = sortBy == SortOrder.MOD ? ThEItemSorters.CONFIG_BASED_SORT_BY_MOD : (sortBy == SortOrder.AMOUNT ? ThEItemSorters.CONFIG_BASED_SORT_BY_SIZE : (sortBy == SortOrder.INVTWEAKS ? ThEItemSorters.CONFIG_BASED_SORT_BY_INV_TWEAKS : ThEItemSorters.CONFIG_BASED_SORT_BY_NAME));
        return c;
    }

    public boolean searchByQuery(boolean searchSpecific, boolean searchByAspect, boolean searchByMod, T t, Pattern pattern) {
        if (searchSpecific) {
            if (searchByAspect) {
                return this.searchAspects(t, pattern);
            }
            if (searchByMod) {
                return this.searchMod(t, pattern);
            }
        } else {
            if (searchByAspect && this.searchAspects(t, pattern)) {
                return true;
            }
            if (searchByMod && this.searchMod(t, pattern)) {
                return true;
            }
            return this.searchName(t, pattern) || this.searchTooltip(t, pattern);
        }
        return true;
    }

    public void postUpdate(T stack) {
        IAEStack existing = this.list.findPrecise(stack);
        if (existing != null) {
            existing.reset();
            existing.add(stack);
        } else {
            this.list.add(stack);
        }
        this.changed = true;
    }

    public T getReferenceStack(int i) {
        int scroll = (int)Math.max(Math.min((double)this.scrollBar.getCurrentPosition(), Math.ceil((double)this.view.size() / (double)this.rowSize)), 0.0);
        if ((i += scroll * this.rowSize) < this.view.size()) {
            return (T)((IAEStack)this.view.get(i));
        }
        return null;
    }

    public int size() {
        return this.view.size();
    }

    public void clear() {
        this.list.resetStatus();
    }

    public void setScrollBar(GuiScrollBar scrollBar) {
        this.scrollBar = scrollBar;
    }

    public GuiScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setViewMode(ViewItems view) {
        this.viewMode = view;
    }

    public ViewItems getViewMode() {
        return this.viewMode;
    }

    public SortDir getSortDir() {
        return this.sortDir;
    }

    public void setSortDir(SortDir sortDir) {
        this.sortDir = sortDir;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public SearchBoxMode getSearchBoxMode() {
        return this.searchBoxMode;
    }

    public void setSearchBoxMode(SearchBoxMode searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    private boolean searchName(T stack, Pattern p) {
        return p.matcher(Platform.getItemDisplayName(stack)).find();
    }

    private boolean searchTooltip(T stack, Pattern p) {
        boolean terminalSearchToolTips;
        boolean bl = terminalSearchToolTips = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_TOOLTIPS) != YesNo.NO;
        if (!terminalSearchToolTips) {
            return true;
        }
        List tooltip = Platform.getTooltip(stack);
        for (String line : tooltip) {
            if (!p.matcher(line).find()) continue;
            return true;
        }
        return false;
    }

    private boolean searchMod(T stack, Pattern p) {
        if (stack instanceof IAEItemStack) {
            return p.matcher(Platform.getModId((IAEItemStack)((IAEItemStack)stack))).find();
        }
        if (stack instanceof IAEFluidStack) {
            return p.matcher(Platform.getModId((IAEFluidStack)((IAEFluidStack)stack))).find();
        }
        return true;
    }

    private boolean searchAspects(T stack, Pattern p) {
        AspectList aspects = TCUtil.getItemAspects(stack.asItemStackRepresentation());
        if (aspects == null || aspects.size() < 1) {
            return false;
        }
        Pattern pf = p;
        Stream stream = aspects.aspects.keySet().stream();
        return stream.anyMatch(aspect -> pf.matcher(aspect.getName()).find());
    }
}

