/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.m_geothermal.tile;

import com.valkyrieofnight.sg.m_generators.inventory.ContainerGenBase;
import com.valkyrieofnight.sg.m_generators.m_geothermal.GGeothermal;
import com.valkyrieofnight.sg.m_generators.m_geothermal.gui.GuiGenGeothermal;
import com.valkyrieofnight.sg.m_generators.tile.TileGenBaseFluid;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vliblegacy.lib.inventory.VLContainer;
import com.valkyrieofnight.vliblegacy.lib.util.ConfigCategoryUtil;
import com.valkyrieofnight.vliblegacy.m_guide.registry.TileData;
import com.valkyrieofnight.vliblegacy.m_guide.registry.TileDataProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;

public class TileGeothermalUpgradable
extends TileGenBaseFluid {
    public static ConfigCategoryUtil CCU;
    public static int GEN_CAPACITOR;
    public static int GEN_TANK;
    public static int GEN_MODIFIER_SLOTS;
    public static TileDataProvider DP;

    public static void loadConfigs(ConfigCategory config) {
        GEN_CAPACITOR = ConfigCategoryUtil.getInt((ConfigCategory)config, (String)"gen_upgradable_capacitor", (int)GEN_CAPACITOR, (int)8000, (int)32000000, (String)"How much RF can this gen store?");
        GEN_TANK = ConfigCategoryUtil.getInt((ConfigCategory)config, (String)"gen_simple_tank", (int)GEN_TANK, (int)64000, (int)256000, (String)"How much fluid this generator can store");
    }

    public TileGeothermalUpgradable() {
        super(GEN_CAPACITOR, GEN_MODIFIER_SLOTS, GEN_TANK);
    }

    protected int getRFTotalFromFuelPerDuration(FluidStack fuel) {
        if (fuel == null) {
            return 0;
        }
        Fluid fl = fuel.getFluid();
        return GGeothermal.GEOTHERMAL_REG_SIMPLE.getEnergyValue(fl);
    }

    @Override
    protected boolean isValidFluid(FluidStack fuel) {
        if (fuel == null) {
            return false;
        }
        Fluid fl = fuel.getFluid();
        return GGeothermal.GEOTHERMAL_REG_SIMPLE.isValidConsumable(fl);
    }

    @Override
    protected boolean isValidInputStack(ItemStack stack) {
        if (stack == null || stack == ItemStack.field_190927_a) {
            return false;
        }
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandler fh = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fh == null) {
                return false;
            }
            for (IFluidTankProperties tp : fh.getTankProperties()) {
                FluidStack fs = tp.getContents();
                if (fs == null) continue;
                return GGeothermal.GEOTHERMAL_REG_SIMPLE.isValidConsumable(fs.getFluid());
            }
        }
        return false;
    }

    @Override
    public EnumFacing[] validConectionDirections() {
        return EnumFacing.field_82609_l;
    }

    @Override
    protected int getDurationForTocks(int tocks, FluidStack fuel) {
        int durTemp = tocks * 40;
        return durTemp;
    }

    @Override
    protected int getRFTotal(int duration, FluidStack fuel) {
        if (fuel == null) {
            return 0;
        }
        int rf = GGeothermal.GEOTHERMAL_REG_SIMPLE.getEnergyValue(fuel.getFluid());
        return duration * rf;
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return 4;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiGenGeothermal(player, (VLContainer)new ContainerGenBase(player.field_71071_by, this), this);
    }

    static {
        GEN_CAPACITOR = 1024000;
        GEN_TANK = 64000;
        GEN_MODIFIER_SLOTS = 4;
        DP = new TileDataProvider("geothermal_upgradable");
        DP.registerData(new TileData("capacitor"){

            public String getLocalizedData() {
                return "" + StringUtils.formatNumber((int)GEN_CAPACITOR);
            }
        });
        DP.registerData(new TileData("tank"){

            public String getLocalizedData() {
                return "" + StringUtils.formatNumber((int)GEN_TANK);
            }
        });
        DP.registerData(new TileData("modifierslots"){

            public String getLocalizedData() {
                return "" + GEN_MODIFIER_SLOTS;
            }
        });
    }
}

