/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.m_geothermal;

import com.google.gson.JsonObject;
import com.valkyrieofnight.sg.SGMod;
import com.valkyrieofnight.sg.m_generators.SGenerators;
import com.valkyrieofnight.sg.m_generators.m_geothermal.features.GBlocks;
import com.valkyrieofnight.sg.m_generators.m_geothermal.features.GeoJei;
import com.valkyrieofnight.sg.m_generators.registry.SingleFluidEntry;
import com.valkyrieofnight.sg.m_generators.registry.SingleFluidJsonRegistry;
import com.valkyrieofnight.sg.m_generators.registry.SingleFluidRegistry;
import com.valkyrieofnight.vliblegacy.lib.module.IFeature;
import com.valkyrieofnight.vliblegacy.lib.module.VLModule;
import java.io.File;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class GGeothermal
extends VLModule {
    private static GGeothermal instance;
    protected SingleFluidJsonRegistry GEOTHERMAL_JSON_SIMPLE;
    protected ArrayList<SingleFluidEntry> defaults = new ArrayList();
    public static SingleFluidRegistry GEOTHERMAL_REG_SIMPLE;

    public static GGeothermal getInstance() {
        if (instance == null) {
            instance = new GGeothermal();
        }
        return instance;
    }

    public GGeothermal() {
        super("geothermal", (VLModule)SGenerators.getInstance());
    }

    protected void initModule() {
        this.GEOTHERMAL_JSON_SIMPLE = new SingleFluidJsonRegistry(SGMod.GSON, new File("config/" + this.getLocation() + "fuels.json"));
        GEOTHERMAL_REG_SIMPLE = new SingleFluidRegistry();
    }

    protected void addFeatures() {
        this.addFeature((IFeature)GBlocks.getInstance());
        this.addFeature((IFeature)GeoJei.getInstance());
    }

    protected boolean enabledByDefault() {
        return true;
    }

    protected void preInitCommon(FMLPreInitializationEvent event) {
    }

    protected void initCommon(FMLInitializationEvent event) {
    }

    protected void postInitCommon(FMLPostInitializationEvent event) {
        if (this.GEOTHERMAL_JSON_SIMPLE.doesFileExsist()) {
            this.GEOTHERMAL_JSON_SIMPLE.loadRegistryFromJson();
        }
        this.defaults.add(new SingleFluidEntry("lava", 120));
        this.defaults.add(new SingleFluidEntry("pyrotheum", 2000));
        this.defaults.add(new SingleFluidEntry("ic2hot_coolant", 40));
        this.defaults.add(new SingleFluidEntry("ic2pahoehoe_lava", 80));
        if (!this.GEOTHERMAL_JSON_SIMPLE.doesFileExsist()) {
            this.GEOTHERMAL_JSON_SIMPLE.addAll(this.defaults);
            this.GEOTHERMAL_JSON_SIMPLE.saveRegistryToJson();
        }
        ArrayList entries = this.GEOTHERMAL_JSON_SIMPLE.getData();
        for (SingleFluidEntry sfe : entries) {
            if (sfe.getFluid() == null) continue;
            GEOTHERMAL_REG_SIMPLE.register(sfe.getFluid(), sfe.getEnergy());
        }
    }

    public static class CraftGeothermalGens
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            return new BooleanSupplier(){

                @Override
                public boolean getAsBoolean() {
                    return GGeothermal.getInstance().isEnabledAndParent();
                }
            };
        }
    }
}

