/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.m_fluidcombustion;

import com.google.gson.JsonObject;
import com.valkyrieofnight.sg.SGMod;
import com.valkyrieofnight.sg.m_generators.SGenerators;
import com.valkyrieofnight.sg.m_generators.m_fluidcombustion.features.FCBlocks;
import com.valkyrieofnight.sg.m_generators.m_fluidcombustion.features.FCJei;
import com.valkyrieofnight.sg.m_generators.registry.SingleFluidEntry;
import com.valkyrieofnight.sg.m_generators.registry.SingleFluidJsonRegistry;
import com.valkyrieofnight.sg.m_generators.registry.SingleFluidRegistry;
import com.valkyrieofnight.vliblegacy.lib.module.IFeature;
import com.valkyrieofnight.vliblegacy.lib.module.VLModule;
import java.io.File;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class GFluidCombustion
extends VLModule {
    private static GFluidCombustion instance;
    protected SingleFluidJsonRegistry FLUID_COMBUSTION_JSON;
    protected ArrayList<SingleFluidEntry> defaults = new ArrayList();
    public static SingleFluidRegistry FLUID_COMBUSTION_REG;

    public static GFluidCombustion getInstance() {
        if (instance == null) {
            instance = new GFluidCombustion();
        }
        return instance;
    }

    public GFluidCombustion() {
        super("fluid_combustion", (VLModule)SGenerators.getInstance());
    }

    protected void initModule() {
        this.FLUID_COMBUSTION_JSON = new SingleFluidJsonRegistry(SGMod.GSON, new File("config/" + this.getLocation() + "fuels.json"));
        FLUID_COMBUSTION_REG = new SingleFluidRegistry();
    }

    protected void addFeatures() {
        this.addFeature((IFeature)FCBlocks.getInstance());
        this.addFeature((IFeature)FCJei.getInstance());
    }

    protected boolean enabledByDefault() {
        return true;
    }

    protected void preInitCommon(FMLPreInitializationEvent event) {
    }

    protected void initCommon(FMLInitializationEvent event) {
    }

    protected void postInitCommon(FMLPostInitializationEvent event) {
        if (this.FLUID_COMBUSTION_JSON.doesFileExsist()) {
            this.FLUID_COMBUSTION_JSON.loadRegistryFromJson();
        }
        this.defaults.add(new SingleFluidEntry("refined_fuel", 1500));
        this.defaults.add(new SingleFluidEntry("ic2biogas", 64));
        this.defaults.add(new SingleFluidEntry("seed_oil", 80));
        this.defaults.add(new SingleFluidEntry("seed.oil", 80));
        this.defaults.add(new SingleFluidEntry("tree_oil", 400));
        this.defaults.add(new SingleFluidEntry("crude_oil", 400));
        this.defaults.add(new SingleFluidEntry("creosote", 40));
        this.defaults.add(new SingleFluidEntry("refined_oil", 1000));
        this.defaults.add(new SingleFluidEntry("coal", 400));
        this.defaults.add(new SingleFluidEntry("refined_biofuel", 800));
        this.defaults.add(new SingleFluidEntry("bio_diesel", 500));
        this.defaults.add(new SingleFluidEntry("biodiesel", 500));
        this.defaults.add(new SingleFluidEntry("diesel", 800));
        this.defaults.add(new SingleFluidEntry("fuel", 1500));
        this.defaults.add(new SingleFluidEntry("rocket_fuel", 1120));
        this.defaults.add(new SingleFluidEntry("fluiddiesel", 800));
        this.defaults.add(new SingleFluidEntry("fluidnitrodiesel", 1600));
        this.defaults.add(new SingleFluidEntry("refinedcanolaoil", 200));
        this.defaults.add(new SingleFluidEntry("crystaloil", 400));
        this.defaults.add(new SingleFluidEntry("empoweredoil", 700));
        this.defaults.add(new SingleFluidEntry("oil", 400));
        this.defaults.add(new SingleFluidEntry("canolaoil", 80));
        this.defaults.add(new SingleFluidEntry("canola_oil", 80));
        this.defaults.add(new SingleFluidEntry("hootch", 360));
        this.defaults.add(new SingleFluidEntry("kerosene", 1500));
        this.defaults.add(new SingleFluidEntry("lpg", 1800));
        this.defaults.add(new SingleFluidEntry("gasoline", 1200));
        this.defaults.add(new SingleFluidEntry("fire_water", 1200));
        this.defaults.add(new SingleFluidEntry("ethanol", 800));
        this.defaults.add(new SingleFluidEntry("bio.ethanol", 800));
        if (!this.FLUID_COMBUSTION_JSON.doesFileExsist()) {
            this.FLUID_COMBUSTION_JSON.addAll(this.defaults);
            this.FLUID_COMBUSTION_JSON.saveRegistryToJson();
        }
        ArrayList entries = this.FLUID_COMBUSTION_JSON.getData();
        for (SingleFluidEntry sfe : entries) {
            if (sfe.getFluid() == null) continue;
            FLUID_COMBUSTION_REG.register(sfe.getFluid(), sfe.getEnergy());
        }
    }

    public static class CraftFluidCombustionGens
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            return new BooleanSupplier(){

                @Override
                public boolean getAsBoolean() {
                    return GFluidCombustion.getInstance().isEnabledAndParent();
                }
            };
        }
    }
}

