/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.m_culinary.tile;

import com.valkyrieofnight.sg.m_generators.inventory.ContainerGenBase;
import com.valkyrieofnight.sg.m_generators.m_culinary.GCulinary;
import com.valkyrieofnight.sg.m_generators.m_culinary.gui.GuiGenCulinary;
import com.valkyrieofnight.sg.m_generators.tile.TileGenBaseItem;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vliblegacy.lib.util.ConfigCategoryUtil;
import com.valkyrieofnight.vliblegacy.m_guide.registry.TileData;
import com.valkyrieofnight.vliblegacy.m_guide.registry.TileDataProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.fml.common.Optional;

public class TileGenCulinarySimple
extends TileGenBaseItem {
    public static ConfigCategoryUtil CCU;
    public static int GEN_CAPACITOR;
    public static int GEN_FUEL_RF_VALUE;
    public static TileDataProvider DP;

    public static void loadConfigs(ConfigCategory config) {
        GEN_CAPACITOR = ConfigCategoryUtil.getInt((ConfigCategory)config, (String)"gen_simple_capacitor", (int)GEN_CAPACITOR, (int)8000, (int)32000000, (String)"How much RF can this gen store?");
        GEN_FUEL_RF_VALUE = ConfigCategoryUtil.getInt((ConfigCategory)config, (String)"gen_simple_fuel_rf_value", (int)GEN_FUEL_RF_VALUE, (int)1, (int)320, (String)"How much RF is generated from a fuel value of 1?");
    }

    public TileGenCulinarySimple() {
        super(GEN_CAPACITOR, 0);
    }

    public static int getRF(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)stack.func_77973_b();
            float h = food.func_150905_g(stack);
            return (int)(24000.0f * (h * food.func_150906_h(stack)));
        }
        return 0;
    }

    @Override
    public EnumFacing[] validConectionDirections() {
        return EnumFacing.values();
    }

    protected int getRFTotal(ItemStack stack) {
        return GCulinary.CULINARY_REG_SIMPLE.getEnergyValue(stack);
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return 1;
    }

    @Override
    protected int getDurationFromFuel(ItemStack fuel) {
        return this.getRFTotal(fuel) / GEN_FUEL_RF_VALUE;
    }

    @Override
    protected int getRFTotalFromFuel(ItemStack fuel) {
        return this.getRFTotal(fuel);
    }

    @Override
    protected boolean isValidInputStack(ItemStack fuel) {
        return GCulinary.CULINARY_REG_SIMPLE.getEnergyValue(fuel) > 0;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiGenCulinary(player, new ContainerGenBase(player.field_71071_by, this), this);
    }

    static {
        GEN_CAPACITOR = 64000;
        GEN_FUEL_RF_VALUE = 80;
        DP = new TileDataProvider("culinary_simple");
        DP.registerData(new TileData("capacitor"){

            public String getLocalizedData() {
                return "" + StringUtils.formatNumber((int)GEN_CAPACITOR);
            }
        });
        DP.registerData(new TileData("energy_tick"){

            public String getLocalizedData() {
                return "" + GEN_FUEL_RF_VALUE;
            }
        });
    }
}

