/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.m_combustion.tile;

import com.valkyrieofnight.sg.m_generators.inventory.ContainerGenBase;
import com.valkyrieofnight.sg.m_generators.m_combustion.GCombustion;
import com.valkyrieofnight.sg.m_generators.m_combustion.gui.GuiGenCombustion;
import com.valkyrieofnight.sg.m_generators.tile.TileGenBaseItem;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vliblegacy.lib.util.ConfigCategoryUtil;
import com.valkyrieofnight.vliblegacy.m_guide.registry.TileData;
import com.valkyrieofnight.vliblegacy.m_guide.registry.TileDataProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;

public class TileGenCombustionSimple
extends TileGenBaseItem {
    public static ConfigCategoryUtil CCU;
    public static int GEN_CAPACITOR;
    public static int GEN_FUEL_RF_VALUE;
    public static TileDataProvider DP;

    public static void loadConfigs(ConfigCategory config) {
        GEN_CAPACITOR = ConfigCategoryUtil.getInt((ConfigCategory)config, (String)"gen_simple_capacitor", (int)GEN_CAPACITOR, (int)8000, (int)32000000, (String)"How much RF can this gen store?");
        GEN_FUEL_RF_VALUE = ConfigCategoryUtil.getInt((ConfigCategory)config, (String)"gen_simple_fuel_rf_value", (int)GEN_FUEL_RF_VALUE, (int)1, (int)320, (String)"How much RF is generated from a fuel value of 1?");
    }

    public static int getRF(ItemStack fuel) {
        int bt = TileEntityFurnace.func_145952_a((ItemStack)fuel) / 4;
        return bt * GEN_FUEL_RF_VALUE;
    }

    public static boolean isValidFuel(ItemStack fuel) {
        if (fuel == ItemStack.field_190927_a) {
            return false;
        }
        if (fuel.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem ifh = (IFluidHandlerItem)fuel.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            IFluidTankProperties[] ft = ifh.getTankProperties();
            if (ft != null && ft.length > 0 && ft[0] != null) {
                FluidStack fluidStack = ft[0].getContents();
            }
            return false;
        }
        return TileGenCombustionSimple.getRF(fuel) > 0;
    }

    public TileGenCombustionSimple() {
        super(GEN_CAPACITOR, 0);
    }

    @Override
    protected boolean isValidInputStack(ItemStack fuel) {
        if (fuel == ItemStack.field_190927_a) {
            return false;
        }
        if (fuel.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem ifh = (IFluidHandlerItem)fuel.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            IFluidTankProperties[] ft = ifh.getTankProperties();
            if (ft != null && ft.length > 0 && ft[0] != null) {
                FluidStack fluidStack = ft[0].getContents();
            }
            return false;
        }
        return GCombustion.COMBUSTION_REG_SIMPLE.getEnergyValue(fuel) > 0;
    }

    @Override
    protected int getDurationFromFuel(ItemStack fuel) {
        return TileEntityFurnace.func_145952_a((ItemStack)fuel);
    }

    @Override
    protected int getRFTotalFromFuel(ItemStack fuel) {
        return GCombustion.COMBUSTION_REG_SIMPLE.getEnergyValue(fuel);
    }

    @Override
    public EnumFacing[] validConectionDirections() {
        return EnumFacing.field_82609_l;
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return 1;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiGenCombustion(player, new ContainerGenBase(player.field_71071_by, this), this);
    }

    static {
        GEN_CAPACITOR = 64000;
        GEN_FUEL_RF_VALUE = 80;
        DP = new TileDataProvider("combustion_simple");
        DP.registerData(new TileData("capacitor"){

            public String getLocalizedData() {
                return "" + StringUtils.formatNumber((int)GEN_CAPACITOR);
            }
        });
        DP.registerData(new TileData("energy_tick"){

            public String getLocalizedData() {
                return "" + GEN_FUEL_RF_VALUE;
            }
        });
    }
}

