/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.transfer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.transfer.ITransferProvider;

@Injects
public final class TransferTileEntity
implements ITransferProvider<TileEntity> {
    private final Map<String, EnumFacing> mappings = new HashMap<String, EnumFacing>();

    public TransferTileEntity() {
        HashMap<String, EnumFacing> mappings = this.mappings;
        mappings.put("below", EnumFacing.DOWN);
        mappings.put("above", EnumFacing.UP);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            mappings.put(facing.func_176610_l(), facing);
        }
    }

    @Override
    @Nullable
    public Object getTransferLocation(@Nonnull TileEntity object, @Nonnull String key) {
        if (key.equals("self")) {
            return object;
        }
        EnumFacing facing = this.mappings.get(key);
        if (facing != null) {
            BlockPos newPos = object.func_174877_v().func_177972_a(facing);
            return object.func_145831_w().func_175625_s(newPos);
        }
        return null;
    }

    @Override
    @Nonnull
    public Set<String> getTransferLocations(@Nonnull TileEntity object) {
        HashSet<String> out = new HashSet<String>();
        out.add("self");
        World world = object.func_145831_w();
        BlockPos pos = object.func_174877_v();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (world.func_175625_s(pos.func_177972_a(facing)) == null) continue;
            out.add(facing.func_176742_j());
        }
        return out;
    }

    @Override
    public boolean secondary() {
        return false;
    }
}

