/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import java.util.List;
import net.minecraft.block.BlockNote;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.module.IModuleContainer;

public final class MethodsNoteblock {
    private static List<SoundEvent> instruments;

    private MethodsNoteblock() {
    }

    private static List<SoundEvent> getInstruments() {
        if (instruments == null) {
            instruments = (List)ObfuscationReflectionHelper.getPrivateValue(BlockNote.class, null, (String[])new String[]{"field_176434_a"});
        }
        return instruments;
    }

    private static SoundEvent getInstrument(String name) {
        ResourceLocation id = new ResourceLocation(name);
        for (SoundEvent sound : instruments) {
            if (!sound.getRegistryName().equals((Object)id)) continue;
            return sound;
        }
        return null;
    }

    @PlethoraMethod(module={"minecraft:noteblock"}, doc="function(instrument:string|number, pitch:number[, volume:number]) -- Plays a note block note")
    public static MethodResult playNote(IContext<IModuleContainer> context, @FromContext(value={"origin"}) IWorldLocation location, Object[] arguments) throws LuaException {
        SoundEvent sound;
        List<SoundEvent> instruments = MethodsNoteblock.getInstruments();
        if (arguments.length == 0) {
            throw ArgumentHelper.badArgument((int)0, (String)"string|number", (String)"no value");
        }
        if (arguments[0] instanceof Number) {
            int instrument = ((Number)arguments[0]).intValue();
            org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(instrument, 0, instruments.size() - 1, "Instrument out of bounds (%s)");
            sound = instruments.get(instrument);
        } else if (arguments[0] instanceof String) {
            String name = (String)arguments[0];
            sound = MethodsNoteblock.getInstrument("block.note." + name);
            if (sound == null) {
                throw new LuaException("Unknown instrument '" + name + "'");
            }
        } else {
            throw ArgumentHelper.badArgument((int)0, (String)"string|number", (Object)arguments[0]);
        }
        int pitch = ArgumentHelper.getInt((Object[])arguments, (int)1);
        float volume = (float)ArgumentHelper.optNumber((Object[])arguments, (int)2, (double)3.0);
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(pitch, 0, 24, "Pitch out of bounds (%s)");
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(volume, 0.1, 5.0, "Volume out of bounds (%s)");
        float adjPitch = (float)Math.pow(2.0, (double)(pitch - 12) / 12.0);
        context.unbake().getExecutor().executeAsync(MethodResult.nextTick(() -> {
            BlockPos pos = location.getPos();
            Vec3d vec = location.getLoc();
            World world = location.getWorld();
            world.func_184133_a(null, pos, sound, SoundCategory.RECORDS, volume, adjPitch);
            if (world instanceof WorldServer) {
                ((WorldServer)world).func_180505_a(EnumParticleTypes.NOTE, false, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0, (double)pitch / 24.0, 0.0, 0.0, 1.0, new int[0]);
            }
            return MethodResult.empty();
        }));
        return MethodResult.empty();
    }

    @PlethoraMethod(module={"minecraft:noteblock"}, doc="function(sound:string[, pitch:number][, volume:number]) -- Play a sound")
    public static MethodResult playSound(IContext<IModuleContainer> context, @FromContext(value={"origin"}) IWorldLocation location, Object[] arguments) throws LuaException {
        String name = ArgumentHelper.getString((Object[])arguments, (int)0);
        float pitch = (float)ArgumentHelper.optNumber((Object[])arguments, (int)1, (double)0.0);
        float volume = (float)ArgumentHelper.optNumber((Object[])arguments, (int)2, (double)1.0);
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(pitch, 0.0, 2.0, "Pitch out of bounds (%s)");
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(volume, 0.1, 5.0, "Volume out of bounds (%s)");
        SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(name));
        if (sound == null) {
            throw new LuaException("No such sound '" + name + "'");
        }
        context.unbake().getExecutor().executeAsync(MethodResult.nextTick(() -> {
            BlockPos pos = location.getPos();
            location.getWorld().func_184133_a(null, pos, sound, SoundCategory.RECORDS, volume, pitch);
            return MethodResult.empty();
        }));
        return MethodResult.empty();
    }
}

