/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.meta;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.WorldLocation;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.api.reference.BlockReference;
import org.squiddev.plethora.utils.WorldDummy;

@Injects
public final class MetaBlockReference
extends BasicMetaProvider<BlockReference> {
    public MetaBlockReference() {
        super("Provides information about blocks which exist in the world.");
    }

    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull BlockReference reference) {
        HashMap<String, Number> data = new HashMap<String, Number>();
        IBlockState state = reference.getState();
        World world = reference.getLocation().getWorld();
        BlockPos pos = reference.getLocation().getPos();
        data.put("hardness", Float.valueOf(state.func_185887_b(world, pos)));
        MapColor mapCol = state.func_185909_g((IBlockAccess)world, pos);
        if (mapCol != null) {
            int colour = mapCol.field_76291_p;
            data.put("colour", colour);
            data.put("color", colour);
        }
        return data;
    }

    @Override
    @Nonnull
    public BlockReference getExample() {
        WorldDummy world = WorldDummy.INSTANCE;
        world.func_175656_a(BlockPos.field_177992_a, Blocks.field_150346_d.func_176223_P());
        return new BlockReference(new WorldLocation((World)world, BlockPos.field_177992_a));
    }
}

