/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.converter;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.converter.DynamicConverter;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.IModuleHandler;
import org.squiddev.plethora.api.module.SingletonModuleContainer;
import org.squiddev.plethora.core.ConfigCore;

@Injects
public final class ConverterTileModule
implements DynamicConverter<TileEntity, IModuleContainer> {
    @Override
    @Nullable
    public IModuleContainer convert(@Nonnull TileEntity from) {
        if (!from.hasCapability(Constants.MODULE_HANDLER_CAPABILITY, null)) {
            return null;
        }
        IModuleHandler handler = (IModuleHandler)from.getCapability(Constants.MODULE_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return null;
        }
        String moduleName = handler.getModule().toString();
        if (ConfigCore.Blacklist.blacklistModules.contains(moduleName) || ConfigCore.Blacklist.blacklistModulesTile.contains(moduleName)) {
            return null;
        }
        return new SingletonModuleContainer(handler.getModule());
    }
}

